<?php
// ✅ Ensure no output before session start
ob_start(); // Buffer output to prevent header errors
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// ✅ Enable debugging for troubleshooting
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'db_connect.php';
require_once 'log_activity.php'; // Include activity log

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $username = trim($_POST["username"]);
    $password = $_POST["password"];

    $stmt = $pdo->prepare("SELECT * FROM admin_users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && md5($password) === $user["password_hash"]) {
        $_SESSION["admin_logged_in"] = true;
        $_SESSION["admin_id"] = $user["id"];
        $_SESSION["admin_username"] = $user["username"];

        // ✅ Log admin login
        logAdminActivity($user["id"], $user["username"], "Logged in");

        // ✅ Update last login timestamp
        $updateStmt = $pdo->prepare("UPDATE admin_users SET last_login = NOW() WHERE id = ?");
        $updateStmt->execute([$user["id"]]);

        header("Location: admin_dashboard.php");
        exit();
    } else {
        $error_message = "❌ Invalid username or password.";
    }
}

// ✅ Prevent additional output issues
ob_end_flush(); // Send output after all processing
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login | Equipe Classic Racing</title>
    <link rel="stylesheet" href="admin_styles.css">
</head>
<body>

    <div class="custom-login-container">
        <div class="custom-login-box">
            <!-- ✅ Company Logo -->
            <img src="assets/logo.svg" alt="Equipe Classic Racing" class="custom-login-logo">

            <h2 style="color:white">Admin Login</h2>
            
            <!-- ✅ Show error message if login fails -->
            <?php if (isset($error_message)): ?>
                <p class="custom-error-message"><?= htmlspecialchars($error_message) ?></p>
            <?php endif; ?>

            <form action="admin_login.php" method="POST">
                <div class="custom-input-group">
                    <label style="color:white">Username</label>
                    <input type="text" name="username" required>
                </div>

                <div class="custom-input-group">
                    <label style="color:white">Password</label>
                    <input type="password" name="password" required>
                </div>

                <button type="submit" class="custom-login-btn">Login</button>
                <!-- ✅ Forgot Password Link -->
                <p class="custom-forgot-password">
                    <a href="forgot_password.php">Forgot Password?</a>
                </p>
            </form>
        </div>
    </div>

</body>
</html>
