<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit();
}

require 'db_connect.php';

// ✅ Check if the table exists before querying
$tableCheck = $pdo->query("SHOW TABLES LIKE 'admin_activity_logs'");
if ($tableCheck->rowCount() == 0) {
    die("Error: The 'admin_activity_logs' table does not exist.");
}

// ✅ Fetch logs safely (Fix table name & check data)
$query = $pdo->query("
    SELECT log.id, log.admin_username, users.full_name, log.action, log.timestamp
    FROM admin_activity_logs AS log
    LEFT JOIN admin_users AS users ON users.username = log.admin_username
    ORDER BY log.timestamp DESC
");

$logs = $query->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Activity Logs</title>
    <link rel="stylesheet" href="admin_styles.css">
</head>
<body>

    <!-- Sidebar Navigation -->
    <aside class="sidebar">
    <!-- Logo -->
    <div class="sidebar-logo">
        <img src="assets/logo.svg" alt="Equipe Classic Racing Logo">
    </div>
    <h2>Admin Panel</h2>
    <ul>
        <li>
            <a href="submissions.php" class="submissions-toggle">📜 Submissions ▼</a>
            <ul class="sub-menu">
                <li><a href="submissions_approved.php">✅ Approved</a></li>
                <li><a href="submissions_pending.php">⏳ Pending</a></li>
                <li><a href="submissions_rejected.php">❌ Rejected</a></li>
            </ul>
        </li>
        <li><a href="admin_dashboard.php">🏠 Dashboard</a></li>
        <li><a href="user_management.php">👤 User Management</a></li>
        <li><a href="admin_logs.php">📜 Activity Logs</a></li>
        <li><a href="admin_profile.php">🔧 My Profile</a></li>
        <li><a href="logout.php">🚪 Logout</a></li>
    </ul>
</aside>

    <!-- Main Content -->
    <main class="admin-container">
        <h1>Admin Activity Logs</h1>

        <?php if (empty($logs)): ?>
            <p>No activity logs found.</p>
        <?php else: ?>
            <table class="admin-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Admin Username</th>
                        <th>Full Name</th>
                        <th>Action</th>
                        <th>Timestamp</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($logs as $log): ?>
                        <tr>
                            <td><?= htmlspecialchars($log['id']) ?></td>
                            <td><?= htmlspecialchars($log['admin_username']) ?></td>
                            <td><?= htmlspecialchars($log['full_name'] ?? '—') ?></td>
                            <td><?= htmlspecialchars($log['action']) ?></td>
                            <td><?= htmlspecialchars($log['timestamp']) ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </main>

</body>
</html>
