<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit();
}

require 'db_connect.php';

// Fetch admin details
$admin_id = $_SESSION["admin_id"];
$stmt = $pdo->prepare("SELECT * FROM admin_users WHERE id = ?");
$stmt->execute([$admin_id]);
$admin = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Profile</title>
    <link rel="stylesheet" href="admin_styles.css">
</head>
<body>

       <?php include 'sidebar.php'; ?> <!-- Sidebar is included here -->

    <!-- Main Content -->
    <main class="admin-container">
        <h1>My Profile</h1>
        
        <div class="profile-card">
            <img src="uploads/<?= htmlspecialchars($admin['profile_picture']) ?>" class="profile-pic" alt="Profile Picture">
            <h2><?= htmlspecialchars($admin['full_name']) ?></h2>
            <p><strong>Username:</strong> <?= htmlspecialchars($admin['username']) ?></p>
            <p><strong>Email:</strong> <?= htmlspecialchars($admin['email']) ?></p>
            <p><strong>Last Login:</strong> <?= htmlspecialchars($admin['last_login'] ?? "Never") ?></p>
            
            <a href="edit_profile.php" class="edit-btn">Edit Profile</a>
        </div>
    </main>

    <style>
        .profile-card {
            background: white;
            padding: 20px;
            text-align: center;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            width: 50%;
            margin: auto;
        }
        .profile-pic {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            object-fit: cover;
        }
        .edit-btn {
            display: inline-block;
            margin-top: 15px;
            padding: 10px 20px;
            background: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
        }
    </style>

</body>
</html>
