<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit();
}

require 'db_connect.php';
$admin_id = $_SESSION["admin_id"];

// Fetch admin details
$stmt = $pdo->prepare("SELECT * FROM admin_users WHERE id = ?");
$stmt->execute([$admin_id]);
$admin = $stmt->fetch(PDO::FETCH_ASSOC);

// Handle form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $full_name = trim($_POST["full_name"]);
    $email = trim($_POST["email"]);
    $password = trim($_POST["password"]);

    // Handle Profile Picture Upload
    if ($_FILES["profile_picture"]["name"]) {
        $target_dir = "uploads/";
        $target_file = $target_dir . basename($_FILES["profile_picture"]["name"]);
        move_uploaded_file($_FILES["profile_picture"]["tmp_name"], $target_file);

        // Update picture in database
        $stmt = $pdo->prepare("UPDATE admin_users SET profile_picture = ? WHERE id = ?");
        $stmt->execute([$target_file, $admin_id]);
        $_SESSION["admin_profile_pic"] = $target_file;
    }

    // Update details in database
    if (!empty($password)) {
        $password_hash = md5($password);
        $stmt = $pdo->prepare("UPDATE admin_users SET full_name = ?, email = ?, password_hash = ? WHERE id = ?");
        $stmt->execute([$full_name, $email, $password_hash, $admin_id]);
    } else {
        $stmt = $pdo->prepare("UPDATE admin_users SET full_name = ?, email = ? WHERE id = ?");
        $stmt->execute([$full_name, $email, $admin_id]);
    }

    header("Location: admin_profile.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Profile</title>
    <link rel="stylesheet" href="admin_styles.css">
</head>
<body>

<?php include 'sidebar.php'; ?> <!-- Sidebar is included here -->

<!-- Main Content -->
<main class="admin-container">
    <h1>Edit Profile</h1>

    <div class="profile-container">
        <div class="profile-picture">
            <img id="profilePreview" src="<?= !empty($admin['profile_picture']) ? $admin['profile_picture'] : 'assets/default-avatar.png'; ?>" alt="Profile Picture">
        </div>

        <form action="" method="POST" enctype="multipart/form-data">
            <label>Full Name:</label>
            <input type="text" name="full_name" value="<?= htmlspecialchars($admin['full_name']) ?>" required>

            <label>Email:</label>
            <input type="email" name="email" value="<?= htmlspecialchars($admin['email']) ?>" required>

            <label>Password (Leave blank to keep current):</label>
            <input type="password" name="password">

            <label>Profile Picture:</label>
            <input type="file" name="profile_picture" onchange="previewImage(event)">

            <button type="submit" class="save-btn">💾 Save Changes</button>
        </form>
    </div>
</main>

<!-- JavaScript -->
<script>
    function previewImage(event) {
        var reader = new FileReader();
        reader.onload = function(){
            var output = document.getElementById('profilePreview');
            output.src = reader.result;
        };
        reader.readAsDataURL(event.target.files[0]);
    }
</script>

<!-- CSS Styling -->
<style>
    /* General Styles */
    body {
        font-family: Arial, sans-serif;
        background: #f8f9fa;
        margin: 0;
        padding: 0;
    }

    /* Sidebar */
    .sidebar {
        width: 250px;
        height: 100vh;
        background: #343a40;
        color: #fff;
        position: fixed;
        padding-top: 20px;
    }

    .sidebar-logo {
        text-align: center;
        margin-bottom: 20px;
    }

    .sidebar-logo img {
        width: 150px;
    }

    .sidebar h2 {
        text-align: center;
        margin-bottom: 20px;
    }

    .sidebar ul {
        list-style: none;
        padding: 0;
    }

    .sidebar ul li {
        padding: 10px;
    }

    .sidebar ul li a {
        color: #fff;
        text-decoration: none;
        display: block;
    }

    .sidebar ul li a.active {
        background: #007bff;
        border-radius: 5px;
    }

    /* Main Content */
    .admin-container {
        margin-left: 270px;
        padding: 20px;
    }

    h1 {
        margin-bottom: 20px;
    }

    /* Profile Container */
    .profile-container {
        background: #fff;
        padding: 20px;
        border-radius: 10px;
        box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        max-width: 500px;
        margin: auto;
    }

    /* Profile Picture */
    .profile-picture {
        text-align: center;
        margin-bottom: 20px;
    }

    .profile-picture img {
        width: 120px;
        height: 120px;
        border-radius: 50%;
        object-fit: cover;
        border: 3px solid #007bff;
    }

    /* Form Styles */
    form {
        display: flex;
        flex-direction: column;
    }

    label {
        font-weight: bold;
        margin-top: 10px;
    }

    input {
        padding: 8px;
        border: 1px solid #ddd;
        border-radius: 5px;
        margin-top: 5px;
    }

    .save-btn {
        background: #007bff;
        color: white;
        padding: 10px;
        border: none;
        cursor: pointer;
        margin-top: 15px;
        border-radius: 5px;
    }

    .save-btn:hover {
        background: #0056b3;
    }
</style>

</body>
</html>
