<?php
session_start();
require 'db_connect.php'; // 🔹 Separate config file for database connection

// ✅ Check if admin is logged in
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.html");
    exit();
}

// ✅ Function to fetch submission
function getSubmission($pdo, $id) {
    $stmt = $pdo->prepare("SELECT * FROM car_submissions WHERE id = ?");
    $stmt->execute([$id]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
}
// Function to handle secure image uploads with unique filenames
function uploadImage($input_name, $old_image = null) {
    if (isset($_FILES[$input_name]) && $_FILES[$input_name]['error'] == 0) {
        $target_dir = "uploads/";
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0775, true); // Create folder if not exists
        }

        $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];
        $file_extension = strtolower(pathinfo($_FILES[$input_name]["name"], PATHINFO_EXTENSION));

        if (!in_array($file_extension, $allowed_extensions)) {
            return $old_image; // Return old image if invalid file type
        }

        // ✅ Generate a unique filename
        $unique_id = time() . '_' . uniqid();
        $new_filename = $unique_id . '.' . $file_extension;
        $target_file = $target_dir . $new_filename;

        if (move_uploaded_file($_FILES[$input_name]["tmp_name"], $target_file)) {
            // ✅ Delete old image if it exists
            if ($old_image && file_exists($old_image)) {
                unlink($old_image);
            }
            return $target_file; // ✅ Return new file path for database update
        }
    }
    return $old_image; // Return old image if no new file uploaded
}


function updateSubmission($pdo, $data) {
    $id = $data['id'];
    unset($data['id']);

    // ✅ SECTION 1 — Owner & Vehicle Details + Chassis
    $validFields = [
        'owner_name',
        'email',
        'vehicle_model',
        'equipe_series',
        'equipe_class',
        'spec_conform',
        'spec_details',
        'fia_homologation',

        'chassis_correct',
        'chassis_details',
        'chassis_material',
        'chassis_construction',
        'chassis_stiffening',
        'chassis_stiffening_details',
        
     // ✅ SECTION 1 + 2 — Owner & Vehicle Details + Chassis + Suspension
        // --- Owner & Vehicle Details
        'owner_name',
        'email',
        'vehicle_model',
        'equipe_series',
        'equipe_class',
        'spec_conform',
        'spec_details',
        'fia_homologation',

        // --- Chassis
        'chassis_correct',
        'chassis_details',
        'chassis_material',
        'chassis_construction',
        'chassis_stiffening',
        'chassis_stiffening_details',

        // --- Suspension
        'front_suspension_original',
        'front_suspension_details',
        'rear_suspension_original',
        'rear_suspension_details',
        'front_suspension_type',
        'rear_suspension_type',
        'front_adjustable_dampers',
        'front_damper_adjusters',
        'rear_adjustable_dampers',
        'rear_damper_adjusters',
        'anti_roll_bar',
    
    // --- ✅ Section 3: Engine
        'engine_correct',
        'engine_details',
        'engine_position_correct',
        'engine_position_details',
        'engine_capacity',
        'engine_stroke',
        'engine_bore',

        // --- Fuel Supply
        'fuel_type',
        'fuel_correct',
        'fuel_details',
        'fuel_make',
        'fuel_size',

        // --- Lubrication
        'lubrication_correct',
        'lubrication_details',
        'sump_type',
        'oil_cooler', // Converted before calling function
        
        // --- ✅ Section 4: Gearbox & Transmission
    'gearbox_make', 'gearbox_gears', 'transmission_correct',
    'transmission_details', 'limited_slip',

    // --- ✅ Section 4: Front Brakes
    'front_brakes_correct', 'front_brakes_details',
    'front_brake_type', 'front_brake_diameter', 'front_brake_width',

    // --- ✅ Section 4: Rear Brakes
    'rear_brakes_correct', 'rear_brakes_details',
    'rear_brake_type', 'rear_brake_diameter',
    
    // --- ✅ Section 5: Body
    'body_correct', 'body_details', 'body_material',

    // --- ✅ Section 5: Tyres
    'tyre_brand', 'tyre_front_dimensions', 'tyre_rear_dimensions',

    // --- ✅ Section 5: Photos
    'photo_front_right', 'photo_rear_left', 'photo_front_brakes',
    'photo_rear_brakes', 'photo_dashboard',
    'photo_engine_right', 'photo_engine_left',
     ];

    // Filter incoming data against allowed fields
    $filteredData = array_intersect_key($data, array_flip($validFields));

    // Build dynamic SQL
    $setFields = [];
    foreach ($filteredData as $key => $value) {
        $setFields[] = "$key = ?";
    }

    $sql = "UPDATE car_submissions SET " . implode(', ', $setFields) . " WHERE id = ?";
    $stmt = $pdo->prepare($sql);

    // Return execution result
    return $stmt->execute([...array_values($filteredData), $id]);
}


foreach ($_POST as $key => $value) {
    if (!is_array($value)) {
        $_POST[$key] = trim($value ?? '');
    }
}



// ✅ Get submission ID from URL
if (!isset($_GET['id'])) {
    die("Invalid request.");
}

$submission_id = $_GET['id'];
$submission = getSubmission($pdo, $submission_id);
if (!$submission) {
    die("Submission not found.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // ✅ Convert oil_cooler array into comma-separated string BEFORE saving
    if (isset($_POST['oil_cooler']) && is_array($_POST['oil_cooler'])) {
        $_POST['oil_cooler'] = implode(', ', $_POST['oil_cooler']);
    } else {
        $_POST['oil_cooler'] = '';
    }

    if (updateSubmission($pdo, $_POST)) {
        echo "<script>alert('Submission updated successfully!'); window.location.href='view_submission.php?id=$submission_id';</script>";
        exit();
    } else {
        echo "<script>alert('Error updating submission. Please try again.');</script>";
    }

    // ... the rest of your image update logic stays below
    try {
        // ✅ Fetch existing images from the database
        $stmt = $pdo->prepare("SELECT * FROM car_submissions WHERE id = ?");
        $stmt->execute([$_POST['id']]);
        $existing_submission = $stmt->fetch(PDO::FETCH_ASSOC);

        // ✅ Process uploaded images (keep old if no new file)
        $photo_front_right = uploadImage('photo_front_right', $existing_submission['photo_front_right']);
        $photo_rear_left = uploadImage('photo_rear_left', $existing_submission['photo_rear_left']);
        $photo_front_brakes = uploadImage('photo_front_brakes', $existing_submission['photo_front_brakes']);
        $photo_rear_brakes = uploadImage('photo_rear_brakes', $existing_submission['photo_rear_brakes']);
        $photo_dashboard = uploadImage('photo_dashboard', $existing_submission['photo_dashboard']);
        $photo_engine_right = uploadImage('photo_engine_right', $existing_submission['photo_engine_right']);
        $photo_engine_left = uploadImage('photo_engine_left', $existing_submission['photo_engine_left']);

        // ✅ Update the database
        $update_stmt = $pdo->prepare("UPDATE car_submissions SET 
            owner_name = ?, email = ?, vehicle_model = ?, equipe_series = ?, equipe_class = ?, 
            photo_front_right = ?, photo_rear_left = ?, photo_front_brakes = ?, photo_rear_brakes = ?, 
            photo_dashboard = ?, photo_engine_right = ?, photo_engine_left = ?
            WHERE id = ?");

        $update_stmt->execute([
            $_POST['owner_name'], $_POST['email'], $_POST['vehicle_model'], $_POST['equipe_series'], $_POST['equipe_class'],
            $photo_front_right, $photo_rear_left, $photo_front_brakes, $photo_rear_brakes,
            $photo_dashboard, $photo_engine_right, $photo_engine_left,
            $_POST['id']
        ]);

        echo "<script>alert('Submission updated successfully!'); window.location.href='view_submission.php?id=" . $_POST['id'] . "';</script>";
        exit();
    } catch (PDOException $e) {
        echo "<script>alert('Database Error: " . $e->getMessage() . "');</script>";
    }
    $selected_oil_coolers = explode(', ', $submission['oil_cooler'] ?? '');
}



?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Submission</title>
    <link rel="stylesheet" href="admin_styles.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
<?php include 'sidebar.php'; ?> <!-- Sidebar is included here -->



    <!-- Main Content (FIXED Layout Issue) -->
    <main class="admin-container">
        <h1>Submission Details</h1>

        <!-- Action Buttons (Styled to Match View Submission) -->
<div class="action-buttons">
    <button onclick="window.location.href='admin_dashboard.php'">⬅️ Go Back</button>
    <button onclick="window.location.href='new_submission.php'">📝 Go to Form</button>
    <button onclick="window.location.href='export_pdf.php?id=<?= $submission_id ?>'">📄 Export to PDF</button>
    <button type="submit" form="editForm">💾 Save Changes</button>
</div>

        <h2 class="text-center">Edit Submission</h2>
        
        <form method="POST" class="card p-4 shadow-sm">
            <input type="hidden" name="id" value="<?= htmlspecialchars($submission['id']) ?>">

            <!-- ✅ Owner & Vehicle Details -->
            <div class="submission-section">
                <h2>Owner & Vehicle Details</h2>
                <div class="mb-3">
                    <label class="form-label">Owner Name:</label>
                    <input type="text" class="form-control" name="owner_name" value="<?= htmlspecialchars($submission['owner_name']) ?>" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Email:</label>
                    <input type="email" class="form-control" name="email" value="<?= htmlspecialchars($submission['email']) ?>" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Vehicle Model:</label>
                    <input type="text" class="form-control" name="vehicle_model" value="<?= htmlspecialchars($submission['vehicle_model']) ?>" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Equipe Series:</label>
                    <select name="equipe_series" class="form-select">
                        <option value="Equipe GTS" <?= $submission['equipe_series'] == 'Equipe GTS' ? 'selected' : '' ?>>Equipe GTS</option>
                        <option value="Equipe Libre" <?= $submission['equipe_series'] == 'Equipe Libre' ? 'selected' : '' ?>>Equipe Libre</option>
                        <option value="Equipe Pre '63" <?= $submission['equipe_series'] == "Equipe Pre '63" ? 'selected' : '' ?>>Equipe Pre '63</option>
                        <option value="Equipe 50s" <?= $submission['equipe_series'] == 'Equipe 50s' ? 'selected' : '' ?>>Equipe 50s</option>
                        <option value="Equipe 70s" <?= $submission['equipe_series'] == 'Equipe 70s' ? 'selected' : '' ?>>Equipe 70s</option>
                        <option value="Equipe MG Cup" <?= $submission['equipe_series'] == 'Equipe MG Cup' ? 'selected' : '' ?>>Equipe MG Cup</option>
                        <option value="Equipe Sports Prototypes" <?= $submission['equipe_series'] == 'Equipe Sports Prototypes' ? 'selected' : '' ?>>Equipe Sports Prototypes</option>
                        <option value="Equipe Sports Racing Cars" <?= $submission['equipe_series'] == 'Equipe Sports Racing Cars' ? 'selected' : '' ?>>Equipe Sports Racing Cars</option>
                        <option value="Equipe Formula Libre" <?= $submission['equipe_series'] == 'Equipe Formula Libre' ? 'selected' : '' ?>>Equipe Formula Libre</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Equipe Class:</label>
                    <select name="equipe_class" class="form-select">
                        <?php
                        $classes = ["1", "2", "3", "4", "5", "6", "7", "A", "B", "C", "D", "E", "R", "M", "Invitation"];
                        foreach ($classes as $class) {
                            echo "<option value=\"$class\" " . ($submission['equipe_class'] == $class ? 'selected' : '') . ">$class</option>";
                        }
                        ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Conforms to Equipe Series Regulations:</label>
                    <select name="spec_conform" class="form-select">
                        <option value="Yes" <?= $submission['spec_conform'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
                        <option value="No" <?= $submission['spec_conform'] == 'No' ? 'selected' : '' ?>>No</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">Specification Details:</label>
                    <textarea name="spec_details" class="form-control"><?= htmlspecialchars($submission['spec_details']) ?></textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">FIA Homologation Number:</label>
                    <input type="text" class="form-control" name="fia_homologation" value="<?= htmlspecialchars($submission['fia_homologation']) ?>">
                </div>
            </div>
            <!-- ✅ Chassis Section -->
<div class="submission-section">
    <h2>Chassis</h2>
    <div class="mb-3">
        <label class="form-label">Chassis Period Correct:</label>
        <select name="chassis_correct" class="form-select">
            <option value="Yes" <?= $submission['chassis_correct'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['chassis_correct'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">Chassis Additional Details:</label>
        <textarea name="chassis_details" class="form-control"><?= htmlspecialchars($submission['chassis_details']) ?></textarea>
    </div>
    <div class="mb-3">
        <label class="form-label">Chassis Material:</label>
        <input type="text" class="form-control" name="chassis_material" value="<?= htmlspecialchars($submission['chassis_material']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Chassis Construction:</label>
        <input type="text" class="form-control" name="chassis_construction" value="<?= htmlspecialchars($submission['chassis_construction']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Additional Stiffening:</label>
        <select name="chassis_stiffening" class="form-select">
            <option value="Yes" <?= $submission['chassis_stiffening'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['chassis_stiffening'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">Stiffening Details:</label>
        <textarea name="chassis_stiffening_details" class="form-control"><?= htmlspecialchars($submission['chassis_stiffening_details']) ?></textarea>
    </div>
</div>

<!-- ✅ Suspension Section -->
<div class="submission-section">
    <h2>Suspension</h2>
    <div class="mb-3">
        <label class="form-label">Front Suspension in Original Position?:</label>
        <select name="front_suspension_original" class="form-select">
            <option value="Yes" <?= $submission['front_suspension_original'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['front_suspension_original'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">If No, Additional Details:</label>
        <textarea name="front_suspension_details" class="form-control"><?= htmlspecialchars($submission['front_suspension_details']) ?></textarea>
    </div>
    <div class="mb-3">
        <label class="form-label">Rear Suspension in Original Position?:</label>
        <select name="rear_suspension_original" class="form-select">
            <option value="Yes" <?= $submission['rear_suspension_original'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['rear_suspension_original'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">If No, Additional Details:</label>
        <textarea name="rear_suspension_details" class="form-control"><?= htmlspecialchars($submission['rear_suspension_details']) ?></textarea>
    </div>
    <div class="mb-3">
        <label class="form-label">Front Suspension Type:</label>
        <input type="text" class="form-control" name="front_suspension_type" value="<?= htmlspecialchars($submission['front_suspension_type']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Rear Suspension Type:</label>
        <input type="text" class="form-control" name="rear_suspension_type" value="<?= htmlspecialchars($submission['rear_suspension_type']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Front Adjustable Dampers?:</label>
        <select name="front_adjustable_dampers" class="form-select">
            <option value="Yes" <?= $submission['front_adjustable_dampers'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['front_adjustable_dampers'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">If Yes, How Many Adjustments?:</label>
        <input type="text" class="form-control" name="front_damper_adjusters" value="<?= htmlspecialchars($submission['front_damper_adjusters']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Rear Adjustable Dampers?:</label>
        <select name="rear_adjustable_dampers" class="form-select">
            <option value="Yes" <?= $submission['rear_adjustable_dampers'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['rear_adjustable_dampers'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">If Yes, How Many Adjustments?:</label>
        <input type="text" class="form-control" name="rear_damper_adjusters" value="<?= htmlspecialchars($submission['rear_damper_adjusters']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Is an Anti Roll Bar Fitted?:</label>
        <select name="anti_roll_bar" class="form-select">
            <option value="Yes" <?= $submission['anti_roll_bar'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['anti_roll_bar'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
</div>
<!-- ✅ Engine Section -->
<div class="submission-section">
    <h2>Engine</h2>
    <div class="mb-3">
        <label class="form-label">Engine Period Correct:</label>
        <select name="engine_correct" class="form-select">
            <option value="Yes" <?= $submission['engine_correct'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['engine_correct'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">If No - Additional Details:</label>
        <textarea name="engine_details" class="form-control"><?= htmlspecialchars($submission['engine_details']) ?></textarea>
    </div>
    <div class="mb-3">
        <label class="form-label">Engine Position Correct:</label>
        <select name="engine_position_correct" class="form-select">
            <option value="Yes" <?= $submission['engine_position_correct'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['engine_position_correct'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">If No - Additional Details:</label>
        <textarea name="engine_position_details" class="form-control"><?= htmlspecialchars($submission['engine_position_details']) ?></textarea>
    </div>
    <div class="mb-3">
        <label class="form-label">Engine Capacity (cc):</label>
        <input type="text" class="form-control" name="engine_capacity" value="<?= htmlspecialchars($submission['engine_capacity']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Engine Stroke (mm):</label>
        <input type="text" class="form-control" name="engine_stroke" value="<?= htmlspecialchars($submission['engine_stroke']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Engine Bore (mm):</label>
        <input type="text" class="form-control" name="engine_bore" value="<?= htmlspecialchars($submission['engine_bore']) ?>">
    </div>
</div>

<!-- ✅ Fuel Supply Section -->
<div class="submission-section">
    <h2>Fuel Supply</h2>
    <div class="mb-3">
        <label class="form-label">Fuel Injection or Carburettor:</label>
        <select name="fuel_type" class="form-select">
            <option value="Fuel Injection" <?= $submission['fuel_type'] == 'Fuel Injection' ? 'selected' : '' ?>>Fuel Injection</option>
            <option value="Carburettor" <?= $submission['fuel_type'] == 'Carburettor' ? 'selected' : '' ?>>Carburettor</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">Fuel System Period Correct?:</label>
        <select name="fuel_correct" class="form-select">
            <option value="Yes" <?= $submission['fuel_correct'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['fuel_correct'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">If No, Additional Details:</label>
        <textarea name="fuel_details" class="form-control"><?= htmlspecialchars($submission['fuel_details']) ?></textarea>
    </div>
    <div class="mb-3">
        <label class="form-label">Fuel System Make:</label>
        <input type="text" class="form-control" name="fuel_make" value="<?= htmlspecialchars($submission['fuel_make']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Carburettor Type & Size:</label>
        <input type="text" class="form-control" name="fuel_size" value="<?= htmlspecialchars($submission['fuel_size']) ?>">
    </div>
</div>
<!-- ✅ Lubrication Section -->
<div class="submission-section">
    <h2>Lubrication</h2>
    <div class="mb-3">
        <label class="form-label">Lubrication Period Correct:</label>
        <select name="lubrication_correct" class="form-select">
            <option value="Yes" <?= $submission['lubrication_correct'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['lubrication_correct'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">If No - Additional Details:</label>
        <textarea name="lubrication_details" class="form-control"><?= htmlspecialchars($submission['lubrication_details']) ?></textarea>
    </div>
    <div class="mb-3">
        <label class="form-label">Dry/Wet Sump:</label>
        <select name="sump_type" class="form-select">
            <option value="Dry" <?= $submission['sump_type'] == 'Dry' ? 'selected' : '' ?>>Dry</option>
            <option value="Wet" <?= $submission['sump_type'] == 'Wet' ? 'selected' : '' ?>>Wet</option>
        </select>
    </div>
    <div class="mb-3">
    <label class="form-label">Oil Cooler Fitted To:</label>
    <select name="oil_cooler[]" class="form-select" multiple>
        <?php
        $options = ["Engine", "Gearbox", "Final Drive", "None"];
        $selected_oil_coolers = explode(', ', $submission['oil_cooler'] ?? '');

        foreach ($options as $option) {
            $selected = in_array($option, $selected_oil_coolers) ? 'selected' : '';
            echo "<option value=\"$option\" $selected>$option</option>";
        }
        ?>
    </select>
    <small class="form-text text-muted">Hold Ctrl (Windows) or Cmd (Mac) to select multiple.</small>
</div>


</div>

<!-- ✅ Gearbox & Transmission Section -->
<div class="submission-section">
    <h2>Gearbox & Transmission</h2>
    <div class="mb-3">
        <label class="form-label">Gearbox Make:</label>
        <input type="text" class="form-control" name="gearbox_make" value="<?= htmlspecialchars($submission['gearbox_make']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Number of Forward Gears:</label>
        <input type="number" class="form-control" name="gearbox_gears" value="<?= htmlspecialchars($submission['gearbox_gears']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Is the Transmission Period Correct?:</label>
        <select name="transmission_correct" class="form-select">
            <option value="Yes" <?= $submission['transmission_correct'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['transmission_correct'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">If Not, Additional Details:</label>
        <textarea name="transmission_details" class="form-control"><?= htmlspecialchars($submission['transmission_details']) ?></textarea>
    </div>
    <div class="mb-3">
        <label class="form-label">Final Drive a Limited Slip Differential (LSD)?:</label>
        <select name="limited_slip" class="form-select">
            <option value="Yes" <?= $submission['limited_slip'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['limited_slip'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
</div>
<!-- ✅ Front Brakes Section -->
<div class="submission-section">
    <h2>Front Brakes</h2>
    <div class="mb-3">
        <label class="form-label">Front Brake Period Correct?:</label>
        <select name="front_brakes_correct" class="form-select">
            <option value="Yes" <?= $submission['front_brakes_correct'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['front_brakes_correct'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">If No - Additional Details:</label>
        <textarea name="front_brakes_details" class="form-control"><?= htmlspecialchars($submission['front_brakes_details']) ?></textarea>
    </div>
    <div class="mb-3">
        <label class="form-label">Front Brake Type:</label>
        <input type="text" class="form-control" name="front_brake_type" value="<?= htmlspecialchars($submission['front_brake_type']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Front Brake Diameter (mm):</label>
        <input type="number" class="form-control" name="front_brake_diameter" value="<?= htmlspecialchars($submission['front_brake_diameter']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Front Brake Width (mm):</label>
        <input type="number" class="form-control" name="front_brake_width" value="<?= htmlspecialchars($submission['front_brake_width']) ?>">
    </div>
</div>

<!-- ✅ Rear Brakes Section -->
<div class="submission-section">
    <h2>Rear Brakes</h2>
    <div class="mb-3">
        <label class="form-label">Rear Brake Period Correct?:</label>
        <select name="rear_brakes_correct" class="form-select">
            <option value="Yes" <?= $submission['rear_brakes_correct'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['rear_brakes_correct'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">If No - Additional Details:</label>
        <textarea name="rear_brakes_details" class="form-control"><?= htmlspecialchars($submission['rear_brakes_details']) ?></textarea>
    </div>
    <div class="mb-3">
        <label class="form-label">Rear Brake Type:</label>
        <input type="text" class="form-control" name="rear_brake_type" value="<?= htmlspecialchars($submission['rear_brake_type']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Rear Brake Diameter (mm):</label>
        <input type="number" class="form-control" name="rear_brake_diameter" value="<?= htmlspecialchars($submission['rear_brake_diameter']) ?>">
    </div>
</div>

<!-- ✅ Body Section -->
<div class="submission-section">
    <h2>Body</h2>
    <div class="mb-3">
        <label class="form-label">Body Period Correct?:</label>
        <select name="body_correct" class="form-select">
            <option value="Yes" <?= $submission['body_correct'] == 'Yes' ? 'selected' : '' ?>>Yes</option>
            <option value="No" <?= $submission['body_correct'] == 'No' ? 'selected' : '' ?>>No</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">If No - Additional Details:</label>
        <textarea name="body_details" class="form-control"><?= htmlspecialchars($submission['body_details']) ?></textarea>
    </div>
    <div class="mb-3">
        <label class="form-label">Main Body Material:</label>
        <input type="text" class="form-control" name="body_material" value="<?= htmlspecialchars($submission['body_material']) ?>">
    </div>
</div>

<!-- ✅ Tyres Section -->
<div class="submission-section">
    <h2>Tyres</h2>
    <div class="mb-3">
        <label class="form-label">Tyre Brand:</label>
        <input type="text" class="form-control" name="tyre_brand" value="<?= htmlspecialchars($submission['tyre_brand']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Tyre Front Dimensions:</label>
        <input type="text" class="form-control" name="tyre_front_dimensions" value="<?= htmlspecialchars($submission['tyre_front_dimensions']) ?>">
    </div>
    <div class="mb-3">
        <label class="form-label">Tyre Rear Dimensions:</label>
        <input type="text" class="form-control" name="tyre_rear_dimensions" value="<?= htmlspecialchars($submission['tyre_rear_dimensions']) ?>">
    </div>
</div>

<div class="submission-section">
    <h2>Photographs</h2>
    <table class="submission-table">
        <?php 
        $imageFields = [
            'photo_front_right' => 'Front 3/4 View Right',
            'photo_rear_left' => 'Rear 3/4 View Left',
            'photo_front_brakes' => 'Front Brakes & Suspension',
            'photo_rear_brakes' => 'Rear Brakes & Suspension',
            'photo_dashboard' => 'Dashboard',
            'photo_engine_right' => 'Engine Compartment (Right)',
            'photo_engine_left' => 'Engine Compartment (Left)'
        ];

        foreach ($imageFields as $field => $label): ?>
            <tr>
                <td><?= $label ?>:</td>
                <td>
                    <div class="image-container">
                        <!-- Display Image -->
                        <?php if (!empty($submission[$field])): ?>
                            <img src="<?= htmlspecialchars($submission[$field]) ?>" class="submission-image">
                        <?php else: ?>
                            <p>No image uploaded.</p>
                        <?php endif; ?>

                        <div class="image-actions">
                            <form action="update_image.php" method="POST" enctype="multipart/form-data">
                                <input type="hidden" name="submission_id" value="<?= $submission_id ?>">
                                <input type="hidden" name="image_field" value="<?= $field ?>">

                                <label for="new_<?= $field ?>" class="file-label">Change Image:</label>
                                <input type="file" name="new_image" id="new_<?= $field ?>" class="file-input">

                                <button type="submit" name="update_image" class="update-btn">Upload New</button>
                                
                                <?php if (!empty($submission[$field])): ?>
                                    <button type="submit" name="remove_image" class="remove-btn">Remove Image</button>
                                <?php endif; ?>
                            </form>
                        </div>
                    </div>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>




            <!-- ✅ Buttons -->
            <div class="d-flex justify-content-between">
                <button type="submit" class="btn btn-success">Save Changes</button>
                <a href="view_submission.php?id=<?= $submission_id ?>" class="btn btn-danger">Cancel</a>
            </div>
        </form>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
