<?php
require_once('tcpdf/tcpdf.php');

class CustomPDF extends TCPDF {
    private $owner_name = "";
    private $vehicle_model = "";

    // ✅ Custom method to set submission data
    public function setSubmissionData($owner, $vehicle) {
        $this->owner_name = $owner;
        $this->vehicle_model = $vehicle;
    }

    public function Footer() {
        $this->SetY(-15); // ✅ Position footer 15mm from bottom
        $this->SetFont('helvetica', 'I', 8);
        
        // ✅ Draw a line above footer
        $this->SetDrawColor(0, 0, 0);
        $this->Line(10, $this->GetY(), 200, $this->GetY());

        // ✅ Footer text
        $footerText = "Equipe Technical Passport | " . 
                      "Owner: " . $this->owner_name . 
                      " | Car: " . $this->vehicle_model . 
                      " | Page " . $this->getAliasNumPage() . " of " . $this->getAliasNbPages();

        $this->Cell(0, 10, $footerText, 0, 0, 'C');
    }
}


session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.html");
    exit();
}

require 'db_connect.php';

if (!isset($_GET['id'])) {
    die("Invalid request.");
}

$submission_id = $_GET['id'];
$stmt = $pdo->prepare("SELECT * FROM car_submissions WHERE id = ?");
$stmt->execute([$submission_id]);
$submission = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$submission) {
    die("Submission not found.");
}

$pdf = new CustomPDF();
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(true);
$pdf->AddPage(); // Create the first (cover) page

// ✅ Set Owner Name & Vehicle Model for the Footer
$pdf->setSubmissionData(htmlspecialchars($submission['owner_name']), htmlspecialchars($submission['vehicle_model']));

// ✅ Write HTML content to the PDF
$pdf->writeHTML($html, true, false, true, false, '');

// ✅ Apply HTML & CSS for Booklet Styling
$html = '
<style>
    body { font-family: Arial, sans-serif; color: #333; }
    h1 { font-size: 24px; text-align: center; margin-top: 20px; }
    h2 { font-size: 18px; border-bottom: 2px solid #333; margin-bottom: 10px; padding-bottom: 5px; }
    table { width: 100%; border-collapse: collapse; margin-bottom: 20px; font-size: 12px; }
    th, td { border: 1px solid #ddd; padding: 20px 15px; text-align: left; }
    th { background-color: #f2f2f2; }
    .black-box { background-color: #000; color: white; text-align: center; padding: 20px; }
    .logo { display: block; margin: 10px auto; width: 200px; }
    .section { margin-bottom: 20px; }
    .image-section { text-align: center; margin-top: 20px; }
    .image-container { display: flex; flex-wrap: wrap; justify-content: center; gap: 15px; margin-top: 10px; }
    .image-container img { width: 250px; height: auto; border: 1px solid #ddd; padding: 5px; background: white; }
    table th {
    background-color: #fbda00;
    font-weight: 700;}
     .section-container {
        background: white; /* White background */
        padding: 15px; /* Add padding */
        border-radius: 10px; /* Rounded corners */
        box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.1); /* ✅ Soft shadow */
        margin-bottom: 20px; /* Spacing between sections */
    }


</style>';

// ✅ FRONT COVER PAGE
$html .= '
<div class="black-box">
    <img src="https://technicaldocuments.equipeclassicracing.com/assets/logo.jpg" class="logo">
    <h1>Equipe Technical Passport</h1>
</div>
<p style="text-align: center; margin-top: 20px;">Official Document for Vehicle Technical Review</p>
<p style="text-align: center;">Submission ID: ' . $submission_id . '</p>
<p style="text-align: center; font-style: italic;">Generated on: ' . date("F j, Y") . '</p>';
$html .= '<p style="text-align: center;">
    Vehicle Owner: ' . htmlspecialchars($submission['owner_name']) . ' | Car: ' . htmlspecialchars($submission['vehicle_model']) . ' | Series: ' . htmlspecialchars($submission['equipe_series']) . ' | Class: ' . htmlspecialchars($submission['equipe_class']) . '
</p>';
// ✅ Get Front 3/4 View Right Image URL
$frontImage = !empty($submission['photo_front_right']) 
    ? "https://technicaldocuments.equipeclassicracing.com/" . $submission['photo_front_right'] 
    : null;

// ✅ Add Image Above Owner & Vehicle Details
if ($frontImage) {
    $html .= '
    <div style="text-align: center; margin-bottom: 20px;">
        <img src="' . $frontImage . '" style="max-width: 100%; height: auto; border: 1px solid #ddd; padding: 5px; background: white;">
    </div>';
}
$html .= '<div style="height:150px;"></div>';
$html .= '<div style="height:100px;"></div>';
$html .= '<div style="height:100px;"></div>';

// ✅ Add Vehicle Details
$html .= '
<div class="section-container">
    <h2>Owner & Vehicle Details</h2>
    <table>
        <tr><th>Owner Name</th><td>' . htmlspecialchars($submission['owner_name']) . '</td></tr>
        <tr><th>Email</th><td>' . htmlspecialchars($submission['email']) . '</td></tr>
        <tr><th>Vehicle Model</th><td>' . htmlspecialchars($submission['vehicle_model']) . '</td></tr>
        <tr><th>Equipe Series</th><td>' . htmlspecialchars($submission['equipe_series']) . '</td></tr>
        <tr><th>Equipe Class</th><td>' . htmlspecialchars($submission['equipe_class']) . '</td></tr>
        <tr><th>Conforms to Equipe Series Regulations</th><td>' . htmlspecialchars($submission['spec_conform']) . '</td></tr>
        <tr><th>Specification Details</th><td>' . htmlspecialchars($submission['spec_details']) . '</td></tr>
        <tr><th>FIA Homologation Number</th><td>' . htmlspecialchars($submission['fia_homologation']) . '</td></tr>
    </table>
</div>';


// ✅ Add Chassis Details
$html .= '
<div class="section-container">
    <h2>Chassis Details</h2>
    <table>
        <tr><th>Chassis Period Correct:</th><td>' . htmlspecialchars($submission['chassis_correct']) . '</td></tr>
        <tr><th>Chassis Additional Details:</th><td>' .  htmlspecialchars($submission['chassis_details']) . '</td></tr>
        <tr><th>Chassis Material:</th><td>' . htmlspecialchars($submission['chassis_material']) . '</td></tr>
        <tr><th>Chassis Construction:</th><td>' . htmlspecialchars($submission['chassis_construction']) . '</td></tr>
        <tr><th>Additional Stiffening:</th><td>'. htmlspecialchars($submission['chassis_stiffening']) . '</td></tr>
        <tr><th>Stiffening Details:</th><td>' . htmlspecialchars($submission['chassis_stiffening_details']) . '</td></tr>
    </table>
</div>';

// ✅ Suspension details
$html .= '
<div class="section-container">
    <h2>Suspension</h2>
    <table>
        <tr><th>Front Suspension in original position?:</th><td>' . htmlspecialchars($submission['front_suspension_original']) . '</td></tr>
        <tr><th>If no, additional details?:</th><td>' . htmlspecialchars($submission['front_suspension_details']) . '</td></tr>
        <tr><th>Rear Suspension in original position?:</th><td>' .htmlspecialchars($submission['rear_suspension_original']) . '</td></tr>
        <tr><th>If no, additional details?:</th><td>' . htmlspecialchars($submission['rear_suspension_details']) . '</td></tr>
        <tr><th>Front Suspension Type:</th><td>' . htmlspecialchars($submission['front_suspension_type']) . '</td></tr>
        <tr><th>If Other: Additional Details:</th><td>' . htmlspecialchars($submission['front_suspension_details_other'] ?? '') . '</td></tr>
        <tr><th>Rear Suspension Type:</th><td>' . htmlspecialchars($submission['rear_suspension_type']) . '</td></tr>
        <tr><th>If Other: Additional Details:</th><td>' . htmlspecialchars($submission['rear_suspension_details_other'] ?? '') . '</td></tr>
        <tr><th>Front adjustable dampers?:</th><td>' . htmlspecialchars($submission['front_adjustable_dampers']) . '</td></tr>
        <tr><th>If Yes, how many adjustments?:</th><td>' . htmlspecialchars($submission['front_damper_adjusters']) . '</td></tr>
        <tr><th>Rear adjustable dampers?:</th><td>' . htmlspecialchars($submission['rear_adjustable_dampers']) . '</td></tr>
        <tr><th>If Yes, how many adjustments?:</th><td>' . htmlspecialchars($submission['rear_damper_adjusters']) . '</td></tr>
        <tr><th>Is an anti roll bar fitted?:</th><td>' . htmlspecialchars($submission['anti_roll_bar']) . '</td></tr>
    </table>
</div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
// ✅ Add Engine Details
$html .= '
<div class="section-container" style:"margin-top:50px">
    <h2>Engine Details</h2>
    <table>
        <tr><th>Engine Period Correct:</th><td>' . htmlspecialchars($submission['engine_correct']) . '</td></tr>
        <tr><th>If no - additional details:</th><td>' .htmlspecialchars($submission['engine_details']) . '</td></tr>
        <tr><th>Engine Position Correct:</th><td>' . htmlspecialchars($submission['engine_position_correct']) . '</td></tr>
        <tr><th>If no - additional details:</th><td>' . htmlspecialchars($submission['engine_position_details']) . '</td></tr>
        <tr><th>Engine Capacity (cc):</th><td>' . htmlspecialchars($submission['engine_capacity']) . '</td></tr>
        <tr><th>Engine Stroke (mm):</th><td>' . htmlspecialchars($submission['engine_stroke']) . '</td></tr>
        <tr><th>Engine Bore (mm):</th><td>' . htmlspecialchars($submission['engine_bore']) . '</td></tr>
        <tr><th>Intake Valve Size (mm):</th><td>' . htmlspecialchars($submission['valve_size_inlet']) . '</td></tr>
        <tr><th>Exhaust Valve Size (mm):</th><td>' . htmlspecialchars($submission['valve_size_exhaust']) . '</td></tr>
        <tr><th>Ignition Type:</th><td>' . htmlspecialchars($submission['ignition']) . '</td></tr>
    </table>
</div>';
// ✅ Fuel
$html .= '
<div class="section-container">
    <h2>Fuel Supply</h2>
    <table>
        <tr><th>Fuel Injecton or Carburettor:</th><td>' . htmlspecialchars($submission['fuel_type']) . '</td></tr>
        <tr><th>Fuel System Period Correct?</th><td>' . htmlspecialchars($submission['fuel_correct']) . '</td></tr>
        <tr><th>If no, Additional details:</th><td>' . htmlspecialchars($submission['fuel_details']) . '</td></tr>
        <tr><th>Fuel System Make:</th><td>' . htmlspecialchars($submission['fuel_make']) . '</td></tr>
        <tr><th>Carburrettor type and size:</th><td>' . htmlspecialchars($submission['fuel_size']) . '</td></tr>
    </table>
</div>';

// ✅ Lubrication
$html .= '
<div class="section-container">
    <h2>Lubrication</h2>
    <table>
        <tr><th>Lubrication Period Correct:</th><td>' . htmlspecialchars($submission['lubrication_correct']) . '</td></tr>
        <tr><th>If no - additional details:</th><td>' . htmlspecialchars($submission['lubrication_details']) . '</td></tr>
        <tr><th>Dry/Wet Sump</th><td>' . htmlspecialchars($submission['sump_type']) . '</td></tr>
        <tr><th>Oil Cooler:</th><td>' . htmlspecialchars($submission['oil_cooler']) . '</td></tr>
    </table>
</div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';

// ✅ Gearbox - Transmission  - clutch
$html .= '
<div class="section-container">
    <h2>Gearbox / Transmission</h2>
    <table>
        <tr><th>Gearbox Make:</th><td>' . htmlspecialchars($submission['gearbox_make']) . '</td></tr>
        <tr><th>Number of Forward Gears:</th><td>' . htmlspecialchars($submission['gearbox_gears']) . '</td></tr>
        <tr><th>Is the transmission period correct?</th><td>' . htmlspecialchars($submission['transmission_correct']) . '</td></tr>
        <tr><th>If not, additional details:</th><td>' . htmlspecialchars($submission['transmission_details']) . '</td></tr>
        <tr><th>Final Drive a LSD?:</th><td>' . htmlspecialchars($submission['limited_slip']) . '</td></tr>
        <tr><th>Clutch Type:</th><td>' . htmlspecialchars($submission['clutch_type']) . '</td></tr>
        <tr><th>Number of Clutch Plates:</th><td>' . htmlspecialchars($submission['number_of_clutch_plates']) . '</td></tr>
        <tr><th>Clutch Operation:</th><td>' . htmlspecialchars($submission['operation']) . '</td></tr>
        <tr><th>Original Operation:</th><td>' . htmlspecialchars($submission['original_operation']) . '</td></tr>
    </table>
</div>';

// ✅ Front Brakes
$html .= '
<div class="section-container">
    <h2>Front Brakes</h2>
    <table>
        <tr><th>Front Brake period correct?</th><td>' . htmlspecialchars($submission['front_brakes_correct']) . '</td></tr>
        <tr><th>If no - additional details:</th><td>' . htmlspecialchars($submission['front_brakes_details']) . '</td></tr>
        <tr><th>Front Brake Type:</th><td>' . htmlspecialchars($submission['front_brake_type']) . '</td></tr>
        <tr><th>If "Other"- additional details:</th><td>' . htmlspecialchars($submission['front_brake_other']) . '</td></tr>
        <tr><th>Front Brake Diameter (mm):</th><td>' . htmlspecialchars($submission['front_brake_diameter']) . '</td></tr>
        <tr><th>Front Brake Width (mm):</th><td>' . htmlspecialchars($submission['front_brake_width']) . '</td></tr>
        <tr><th>Number of front brake Calipers/pistons (per Wheel) :</th><td>' . htmlspecialchars($submission['front_brake_calipers']) . '</td></tr>
        <tr><th>Bias Pedalbox:</th><td>' . htmlspecialchars($submission['bias_pedalbox']) . '</td></tr>
        <tr><th>Front Disk Type:</th><td>' . htmlspecialchars($submission['front_disk_type']) . '</td></tr>
        <tr><th>Front Disk Material:</th><td>' . htmlspecialchars($submission['front_disk_material']) . '</td></tr>
    </table>
</div>';

// ✅ Rear Brakes
$html .= '
<div class="section-container">
    <h2>Rear Brakes</h2>
    <table>
        <tr><th>Rear Brake period correct?</th><td>' . htmlspecialchars($submission['rear_brakes_correct']) . '</td></tr>
        <tr><th>If no - additional details:</th><td>' . htmlspecialchars($submission['rear_brakes_details']) . '</td></tr>
        <tr><th>Rear Brake Type:</th><td>' . htmlspecialchars($submission['rear_brake_type']) . '</td></tr>
        <tr><th>If "Other"- additional details:</th><td>' . htmlspecialchars($submission['rear_brake_other']) . '</td></tr>
        <tr><th>Rear Brake Diameter (mm):</th><td>' . htmlspecialchars($submission['rear_brake_diameter']) . '</td></tr>
        <tr><th>Rear Brake Width (mm):</th><td>' . htmlspecialchars($submission['rear_brake_width']) . '</td></tr>
        <tr><th>Number of rear brake Calipers/pistons (per Wheel) :</th><td>' . htmlspecialchars($submission['rear_brake_calipers']) . '</td></tr>
        <tr><th>Front Disk Type:</th><td>' . htmlspecialchars($submission['rear_disk_type']) . '</td></tr>
        <tr><th>Front Disk Material:</th><td>' . htmlspecialchars($submission['rear_disk_material']) . '</td></tr>
    </table>
</div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
// ✅ Body
$html .= '
<div class="section-container">
    <h2>Body</h2>
    <table>
        <tr><th>Body Period Correct:</th><td>' . htmlspecialchars($submission['body_correct']) . '</td></tr>
        <tr><th>If no, Additional details:</th><td>' . htmlspecialchars($submission['body_details']) . '</td></tr>
        <tr><th>Main body material:</th><td>' . htmlspecialchars($submission['body_material']) . '</td></tr>
        <tr><th>Other body materials:</th><td>' . htmlspecialchars($submission['body_other_materials']) . '</td></tr>
    </table>
</div>';

$html .= '<div style="height:200px;"></div>';
$html .= '<div style="height:200px;"></div>';
// ✅ Tyres
$html .= '
<div class="section-container">
    <h2>Tyres</h2>
    <table>
        <tr><th>Tyre Brand:</th><td>' . htmlspecialchars($submission['tyre_brand']) . '</td></tr>
        <tr><th>Tyre Front Dimensions:</th><td>' . htmlspecialchars($submission['tyre_front_dimensions']) . '</td></tr>
        <tr><th>Tyre Rear Dimensions:</th><td>' . htmlspecialchars($submission['tyre_rear_dimensions']) . '</td></tr>
    </table>
</div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
$html .= '<div style="height:120px;"></div>';
// ✅ Add Page Break for Images
$pdf->AddPage();

// ✅ Add Images Section
$html .= '<div class="image-section">
    <h2>Photographs</h2>
    <table style="width:100%; border-collapse: collapse;">';;

// ✅ List of image fields
$imageFields = [
    'photo_front_right' => 'Front 3/4 View Right',
    'photo_rear_left' => 'Rear 3/4 View Left',
    'photo_front_brakes' => 'Front Brakes & Suspension',
    'photo_rear_brakes' => 'Rear Brakes & Suspension',
    'photo_dashboard' => 'Dashboard',
    'photo_engine_right' => 'Engine Compartment (Right)',
    'photo_engine_left' => 'Engine Compartment (Left)',
];

$counter = 0;
foreach ($imageFields as $field => $label) {
    if (!empty($submission[$field])) {
        // Start a new row every two images
        if ($counter % 3 == 0) {
            if ($counter > 0) {
                $html .= '</tr>';
            }
            $html .= '<tr>';
        }
        $imagePath = "https://technicaldocuments.equipeclassicracing.com/" . $submission[$field];
        $html .= '<td style="text-align: center; padding: 5px;">
                    <p><strong>' . $label . '</strong></p>
                    <img src="' . $imagePath . '" class="submission-image" style="max-width:100%;">
                  </td>';
        $counter++;
    }
}

$html .= '</tr>';
$html .= '</table></div>';

$pdf->deletePage(1);
$pdf->deletePage(2);

// ✅ Write the HTML to PDF
$pdf->writeHTML($html, true, false, true, false, '');

// ✅ Output PDF
$pdf->Output("submission_{$submission_id}.pdf", 'I');
?>
