<?php
header('Content-Type: application/json');

require 'db_connect.php';

$input = json_decode(file_get_contents('php://input'), true);
$startDate = $input['startDate'] ?? null;
$endDate = $input['endDate'] ?? null;

if (!$startDate || !$endDate) {
    echo json_encode(['error' => 'Invalid date range']);
    exit();
}

// Prepare queries with date range filter
$submissionTrendsStmt = $pdo->prepare("SELECT DATE_FORMAT(submitted_at, '%Y-%m') AS month, COUNT(*) AS count FROM car_submissions WHERE submitted_at BETWEEN :start AND :end GROUP BY month ORDER BY month");
$submissionTrendsStmt->execute(['start' => $startDate, 'end' => $endDate]);
$submissionTrends = $submissionTrendsStmt->fetchAll(PDO::FETCH_ASSOC);

$statusCountsStmt = $pdo->prepare("SELECT status, COUNT(*) AS count FROM car_submissions WHERE submitted_at BETWEEN :start AND :end GROUP BY status");
$statusCountsStmt->execute(['start' => $startDate, 'end' => $endDate]);
$statusCounts = $statusCountsStmt->fetchAll(PDO::FETCH_ASSOC);

topVehiclesStmt = $pdo->prepare("SELECT vehicle_model, COUNT(*) AS count FROM car_submissions WHERE submitted_at BETWEEN :start AND :end GROUP BY vehicle_model ORDER BY count DESC LIMIT 5");
topVehiclesStmt->execute(['start' => $startDate, 'end' => $endDate]);
topVehicles = $topVehiclesStmt->fetchAll(PDO::FETCH_ASSOC);

$equipeSeriesStmt = $pdo->prepare("SELECT equipe_series, COUNT(*) AS count FROM car_submissions WHERE submitted_at BETWEEN :start AND :end GROUP BY equipe_series ORDER BY count DESC");
$equipeSeriesStmt->execute(['start' => $startDate, 'end' => $endDate]);
$equipeSeries = $equipeSeriesStmt->fetchAll(PDO::FETCH_ASSOC);

// Format response
$response = [
    'submissionTrends' => [
        'labels' => array_column($submissionTrends, 'month'),
        'counts' => array_column($submissionTrends, 'count'),
    ],
    'statusCounts' => [
        'labels' => array_column($statusCounts, 'status'),
        'counts' => array_column($statusCounts, 'count'),
    ],
    'topVehicles' => [
        'labels' => array_column($topVehicles, 'vehicle_model'),
        'counts' => array_column($topVehicles, 'count'),
    ],
    'equipeSeries' => [
        'labels' => array_column($equipeSeries, 'equipe_series'),
        'counts' => array_column($equipeSeries, 'count'),
    ]
];

echo json_encode($response);
