<?php
session_start();
require 'db_connect.php';

// ✅ Ensure only logged-in admins can access
if (!isset($_SESSION["admin_logged_in"])) {
    header("Location: admin_login.php");
    exit();
}

// ✅ Handle form submission
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $username = trim($_POST["username"]);
    $full_name = trim($_POST["full_name"]);
    $email = trim($_POST["email"]);
    $password = password_hash($_POST["password"], PASSWORD_DEFAULT);
    $profile_picture = $_POST["profile_picture"]; // Placeholder (modify for actual file uploads)

    // Check if user already exists
    $stmt = $pdo->prepare("SELECT * FROM admin_users WHERE username = ? OR email = ?");
    $stmt->execute([$username, $email]);

    if ($stmt->rowCount() > 0) {
        $error_message = "❌ Error: Username or email already exists!";
    } else {
        // Insert new admin
        $stmt = $pdo->prepare("INSERT INTO admin_users (username, full_name, email, password_hash, profile_picture, last_login) 
                               VALUES (?, ?, ?, ?, ?, NOW())");
        $stmt->execute([$username, $full_name, $email, $password, $profile_picture]);
        
        $success_message = "✅ User added successfully!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add New Admin</title>
    <link rel="stylesheet" href="admin_styles.css">
</head>
<body>

   <?php include 'sidebar.php'; ?> <!-- Sidebar is included here -->

    <!-- Main Content -->
    <main class="admin-container">
        <h1>Add New Admin</h1>

        <!-- ✅ Success/Error Messages -->
        <?php if (!empty($success_message)): ?>
            <p class="success-msg"><?= htmlspecialchars($success_message) ?></p>
        <?php endif; ?>
        <?php if (!empty($error_message)): ?>
            <p class="error-msg"><?= htmlspecialchars($error_message) ?></p>
        <?php endif; ?>

        <form action="" method="POST" class="admin-form">
            <label>Username:</label>
            <input type="text" name="username" required>

            <label>Full Name:</label>
            <input type="text" name="full_name" required>

            <label>Email:</label>
            <input type="email" name="email" required>

            <label>Password:</label>
            <input type="password" name="password" required>

            <label>Profile Picture URL:</label>
            <input type="text" name="profile_picture" placeholder="Enter profile image URL">

            <button type="submit">Add Admin</button>
        </form>
    </main>

    <!-- ✅ Improved Styling -->
    <style>
        .admin-container {
            padding: 20px;
            margin-left: 280px; /* Adjust to match sidebar */
            max-width: 600px;
            background: #fff;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
        }

        .admin-form {
            display: flex;
            flex-direction: column;
        }

        .admin-form label {
            font-weight: bold;
            margin-top: 10px;
        }

        .admin-form input {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-top: 5px;
        }

        .admin-form button {
            margin-top: 15px;
            padding: 10px;
            border: none;
            cursor: pointer;
            background-color: #007bff;
            color: white;
            border-radius: 5px;
            font-size: 16px;
        }

        .success-msg {
            color: green;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .error-msg {
            color: red;
            font-weight: bold;
            margin-bottom: 10px;
        }
    </style>

</body>
</html>
