<?php
session_start();
require 'db_connect.php';

if (!isset($_GET['token']) || empty($_GET['token'])) {
    die("Invalid or expired reset token.");
}

$token = $_GET['token'];

// Verify token in database
$stmt = $pdo->prepare("SELECT * FROM admin_users WHERE reset_token = ? AND reset_token_expiry > NOW()");
$stmt->execute([$token]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    die("❌ Invalid or expired reset token.");
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $new_password = md5($_POST["new_password"]); // Hash new password

    // Update password in database
    $updateStmt = $pdo->prepare("UPDATE admin_users SET password_hash = ?, reset_token = NULL, reset_token_expiry = NULL WHERE id = ?");
    $updateStmt->execute([$new_password, $user["id"]]);

    echo "✅ Password successfully reset. <a href='admin_login.php'>Login here</a>";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password | Equipe Classic Racing</title>
    <link rel="stylesheet" href="admin_styles.css">
</head>
<body>

    <div class="custom-login-container">
        <div class="custom-login-box">
            <h2>Reset Password</h2>
            <p>Enter a new password for your account.</p>

            <form action="" method="POST">
                <div class="custom-input-group">
                    <label>New Password</label>
                    <input type="password" name="new_password" required>
                </div>

                <button type="submit" class="custom-login-btn">Reset Password</button>
            </form>
        </div>
    </div>

</body>
</html>
