<?php
session_start();
require 'db_connect.php';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email = trim($_POST["email"]);

    // Check if email exists in database
    $stmt = $pdo->prepare("SELECT * FROM admin_users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        // Generate a unique reset token
        $reset_token = bin2hex(random_bytes(32));
        $token_expiry = date("Y-m-d H:i:s", strtotime("+1 hour")); // Expires in 1 hour

        // Store token in database
        $updateStmt = $pdo->prepare("UPDATE admin_users SET reset_token = ?, reset_token_expiry = ? WHERE email = ?");
        $updateStmt->execute([$reset_token, $token_expiry, $email]);

        // Create reset link
        $reset_link = "http://technicaldocuments.equipeclassicracing.com/reset_password.php?token=$reset_token";

        // Send email (This needs to be configured with your mail server)
        $subject = "Password Reset Request";
        $message = "Hello, \n\nClick the link below to reset your password:\n$reset_link\n\nThis link will expire in 1 hour.";
        $headers = "From: no-reply@equipeclassicracing.com";

        if (mail($email, $subject, $message, $headers)) {
            echo "✅ A reset link has been sent to your email.";
        } else {
            echo "❌ Failed to send email.";
        }
    } else {
        echo "❌ No account found with that email.";
    }
}
?>
