<!-- sidebar.php -->
<aside class="sidebar">
    <!-- Logo -->
    <div class="sidebar-logo">
        <img src="assets/logo.svg" alt="Equipe Classic Racing Logo">
    </div>
    <h2>Admin Panel</h2>
    <ul>
        <li>
            <a href="submissions" class="submissions-toggle">📜 All Submissions ▼</a>
            <ul class="sub-menu">
                <li><a href="submissions_approved">✅ Approved</a></li>
                <li><a href="submissions_pending">⏳ Pending</a></li>
                <li><a href="submissions_rejected">❌ Rejected</a></li>
            </ul>
        </li>
        <li><a href="admin_dashboard">🏠 Dashboard</a></li>
        <li><a href="user_management">👤 User Management</a></li>
        <li><a href="admin_logs">📜 Activity Logs</a></li>
        <li><a href="notifications_page">🔔 Notification History</a></li>
        <li><a href="admin_profile">🔧 My Profile</a></li>
        <li><a href="logout">🚪 Logout</a></li>
    </ul>
    <!-- Notifications -->
<div class="sidebar-notifications">
  <div class="bell-wrapper" onclick="toggleNotifications()">
    <span class="bell-icon">🔔 Notifications</span>
    <span id="notification-count" class="notification-count"></span>
  </div>
  
  <button onclick="markAllNotificationsRead()" class="mark-read-btn">Mark All as Read</button>
  
  <ul id="notification-list" class="notification-list"></ul>
</div>
 
</div>
</aside>
<script>
function toggleNotifications() {
    const list = document.getElementById("notification-list");
    list.style.display = list.style.display === "block" ? "none" : "block";
}

function loadNotifications() {
    fetch("fetch_notifications.php")
        .then(res => res.json())
        .then(data => {
            if (!Array.isArray(data)) {
                console.error("Notification response is not an array:", data);
                return;
            }

            const list = document.getElementById("notification-list");
            const count = document.getElementById("notification-count");
            list.innerHTML = "";

            let unread = 0;
            data.forEach(n => {
                const li = document.createElement("li");
                if (n.submission_id) {
                    li.innerHTML = `
                        <a href="view_submission.php?id=${n.submission_id}" style="color:#ccc; text-decoration:none;">
                            ${n.message}
                        </a><br>
                        <small style="color:gray;">${new Date(n.created_at).toLocaleString()}</small>
                    `;
                } else {
                    li.innerHTML = `
                        ${n.message}<br>
                        <small style="color:gray;">${new Date(n.created_at).toLocaleString()}</small>
                    `;
                }
                list.appendChild(li);
                if (!n.is_read) unread++;
            });

            count.textContent = unread;
            count.style.display = unread ? "inline-block" : "none";
        })
        .catch(err => console.error("Notification fetch failed:", err));
}

function markAllNotificationsRead() {
    fetch("update_status.php", {
        method: "POST",
        headers: { "Content-Type": "application/x-www-form-urlencoded" },
        body: "mark_all_read=true"
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            loadNotifications(); // refresh the list
        } else {
            alert('Failed to mark notifications as read.');
        }
    })
    .catch(err => console.error('Error marking notifications as read:', err));
}

document.addEventListener("DOMContentLoaded", () => {
    loadNotifications();
    setInterval(loadNotifications, 30000);
});
</script>

