<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit();
}

require 'db_connect.php';

// Fetch Approved Submissions
$query = $pdo->query("SELECT * FROM car_submissions WHERE status = 'Pending' ORDER BY submitted_at DESC");
$submissions = $query->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Approved Submissions</title>
    <link rel="stylesheet" href="admin_styles.css">
</head>
<body>

    <?php include 'sidebar.php'; ?> <!-- Sidebar is included here -->

    <!-- Main Content -->
    <main class="admin-container">
        <h1>Approved Submissions</h1>
        <a href="submissions.php" class="back-btn">⬅ Back to All Submissions</a>
<div class="filter-container">
        <input type="text" id="search" placeholder="Search submissions..." onkeyup="searchTable()">
        
        <label for="filterStatus">Filter by Status:</label>
        <select id="filterStatus" onchange="filterTable()">
            <option value="">All Statuses</option>
            <option value="Pending">Pending</option>
            <option value="Approved">Approved</option>
            <option value="Rejected">Rejected</option>
        </select>

        <button onclick="exportCSV()" style="margin-top:3px">Export CSV</button>
    </div>
        <table class="admin-table">
            <thead>
                <tr>
                <th onclick="sortTable(0)">ID</th>
                <th onclick="sortTable(1)">Owner Name</th>
                <th onclick="sortTable(2)">Vehicle</th>
                <th onclick="sortTable(3)">Status</th>
                <th onclick="sortTable(4)">Equipe Series</th>
                    <th onclick="sortTable(5)">Equipe Class</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($submissions as $submission): ?>
                <tr>
                    <td><?= htmlspecialchars($submission['id']) ?></td>
                    <td><?= htmlspecialchars($submission['owner_name']) ?></td>
                    <td><?= htmlspecialchars($submission['vehicle_model'])?></td>
                    <td><?= htmlspecialchars($submission['equipe_series']) ?></td>
                    <td><?= htmlspecialchars($submission['equipe_class']) ?></td>
                    
                    <td>
                        <select class="status-dropdown" data-id="<?= $submission['id'] ?>">
                            <option value="Pending" <?= $submission['status'] == 'Pending' ? 'selected' : '' ?>>Pending</option>
                            <option value="Approved" <?= $submission['status'] == 'Approved' ? 'selected' : '' ?>>Approved</option>
                            <option value="Rejected" <?= $submission['status'] == 'Rejected' ? 'selected' : '' ?>>Rejected</option>
                        </select>
                    </td>
                    <td>
                        <a href="view_submission.php?id=<?= $submission['id'] ?>" class="view-btn">View</a>
                        <a href="edit_submission.php?id=<?= $submission['id'] ?>" class="edit-btn">Edit</a>
                        <a href="export_pdf.php?id=<?= $submission['id'] ?>" class="export-btn">Export PDF</a>
                        <a href="javascript:void(0);" class="delete-btn" onclick="confirmDelete(<?= $submission['id'] ?>)">Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
        </table>
    </main>

    <style>
        .back-btn {
            display: inline-block;
            margin-bottom: 15px;
            padding: 10px;
            background: #007bff;
            color: white;
            text-decoration: none;
            border-radius: 5px;
        }
        .back-btn:hover { opacity: 0.8; }
    </style>
</body>
</html>
