<?php
ini_set('log_errors', 1);
ini_set('error_log', '/home/equipeclassic/public_html/form_error_log.txt');

require 'db_connect.php'; // Ensure database connection is included

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    try {
        // Function to handle file uploads securely
       // Function to handle file uploads securely
function uploadImage($input_name) {
    if (isset($_FILES[$input_name]) && $_FILES[$input_name]['error'] == 0) {
        $target_dir = "uploads/"; // Ensure this folder exists
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0775, true); // Create upload folder if not exists
        }

        $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];
        $file_extension = strtolower(pathinfo($_FILES[$input_name]["name"], PATHINFO_EXTENSION));

        if (!in_array($file_extension, $allowed_extensions)) {
            return null; // Invalid file type
        }

        // ✅ Generate a unique filename (Timestamp + Random String)
        $unique_id = time() . '_' . uniqid();
        $new_filename = $unique_id . '.' . $file_extension;

        $target_file = $target_dir . $new_filename;

        if (move_uploaded_file($_FILES[$input_name]["tmp_name"], $target_file)) {
            return $target_file; // ✅ Return file path to be stored in DB
        }
    }
    return null; // No file uploaded or error
}

        // Process image uploads
        $photo_front_right = uploadImage('photo_front_right');
        $photo_rear_left = uploadImage('photo_rear_left');
        $photo_front_brakes = uploadImage('photo_front_brakes');
        $photo_rear_brakes = uploadImage('photo_rear_brakes');
        $photo_dashboard = uploadImage('photo_dashboard');
        $photo_engine_right = uploadImage('photo_engine_right');
        $photo_engine_left = uploadImage('photo_engine_left');

        // Prepare SQL Query
        $sql = "INSERT INTO car_submissions (
            owner_name, email, vehicle_model, equipe_series, equipe_class, spec_conform, spec_details, fia_homologation,
            chassis_correct, chassis_details, chassis_material, chassis_construction, chassis_stiffening, chassis_stiffening_details,
            front_suspension_original, front_suspension_details, rear_suspension_original, rear_suspension_details, 
            front_suspension_type, front_suspension_details_other, rear_suspension_type, rear_suspension_details_other, front_adjustable_dampers, front_damper_adjusters, 
            rear_adjustable_dampers, rear_damper_adjusters, anti_roll_bar,
            engine_correct, engine_details, engine_position_correct, engine_position_details, engine_capacity, engine_stroke, engine_bore,valve_size_exhaust,valve_size_inlet,ignition,
            fuel_type, fuel_correct, fuel_details, fuel_make, fuel_size,
            lubrication_correct, lubrication_details, sump_type, oil_cooler,
            gearbox_make, gearbox_gears, transmission_correct, transmission_details, limited_slip,clutch_type,number_of_clutch_plates,operation,original_operation,
            front_brakes_correct, front_brakes_details, front_brake_type, front_brake_other, front_brake_diameter, 
            front_brake_width, front_brake_calipers, bias_pedalbox, front_disk_type, front_disk_material,
            rear_brakes_correct, rear_brakes_details, rear_brake_type, rear_brake_other, rear_brake_diameter, 
            rear_brake_width, rear_brake_calipers, rear_disk_type, rear_disk_material,
            body_correct, body_details, body_material, body_other_materials,
            tyre_brand, tyre_front_dimensions, tyre_rear_dimensions,
            photo_front_right, photo_rear_left, photo_front_brakes, photo_rear_brakes, 
            photo_dashboard, photo_engine_right, photo_engine_left, status
        ) VALUES (
            :owner_name, :email, :vehicle_model, :equipe_series, :equipe_class, :spec_conform, :spec_details, :fia_homologation,
            :chassis_correct, :chassis_details, :chassis_material, :chassis_construction, :chassis_stiffening, :chassis_stiffening_details,
            :front_suspension_original, :front_suspension_details, :rear_suspension_original, :rear_suspension_details, 
            :front_suspension_type, :front_suspension_details_other, :rear_suspension_type, :rear_suspension_details_other, :front_adjustable_dampers, :front_damper_adjusters, 
            :rear_adjustable_dampers, :rear_damper_adjusters, :anti_roll_bar,
            :engine_correct, :engine_details, :engine_position_correct, :engine_position_details, :engine_capacity, :engine_stroke, :engine_bore,:valve_size_exhaust,:valve_size_inlet,:ignition,
            :fuel_type, :fuel_correct, :fuel_details, :fuel_make, :fuel_size,
            :lubrication_correct, :lubrication_details, :sump_type, :oil_cooler,
            :gearbox_make, :gearbox_gears, :transmission_correct, :transmission_details, :limited_slip, :clutch_type, :number_of_clutch_plates, :operation, :original_operation,
            :front_brakes_correct, :front_brakes_details, :front_brake_type, :front_brake_other, :front_brake_diameter, 
            :front_brake_width, :front_brake_calipers, :bias_pedalbox, :front_disk_type, :front_disk_material,
            :rear_brakes_correct, :rear_brakes_details, :rear_brake_type, :rear_brake_other, :rear_brake_diameter, 
            :rear_brake_width, :rear_brake_calipers, :rear_disk_type, :rear_disk_material,
            :body_correct, :body_details, :body_material, :body_other_materials,
            :tyre_brand, :tyre_front_dimensions, :tyre_rear_dimensions,
            :photo_front_right, :photo_rear_left, :photo_front_brakes, :photo_rear_brakes, 
            :photo_dashboard, :photo_engine_right, :photo_engine_left, :status
        )";

        $stmt = $pdo->prepare($sql);
        // Convert oil cooler array to string (comma-separated)
        $oil_cooler_array = $_POST['oil_cooler'] ?? []; // If not set, default to empty array
        $oil_cooler = implode(', ', $oil_cooler_array); // "Engine, Gearbox"
        $anti_roll_bar = $_POST['anti_roll_bar'] ?? null;

  

    
       $stmt->execute([
    // Owner Details
    ':owner_name' => $_POST['owner_name'],
    ':email' => $_POST['email'],
    ':vehicle_model' => $_POST['vehicle_model'],
    ':equipe_series' => $_POST['equipe_series'],
    ':equipe_class' => $_POST['equipe_class'],
    ':spec_conform' => $_POST['spec_conform'],
    ':spec_details' => $_POST['spec_details'],
    ':fia_homologation'  => is_numeric($_POST['fia_homologation']) ? $_POST['fia_homologation'] : null,

    // Chassis Details
    ':chassis_correct' => $_POST['chassis_correct'],
    ':chassis_details' => $_POST['chassis_details'],
    ':chassis_material' => $_POST['chassis_material'],
    ':chassis_construction' => $_POST['chassis_construction'],
    ':chassis_stiffening' => $_POST['chassis_stiffening'],
    ':chassis_stiffening_details' => $_POST['chassis_stiffening_details'],

    // Suspension
    ':front_suspension_original' => $_POST['front_suspension_original'],
    ':front_suspension_details' => $_POST['front_suspension_details'],
    ':rear_suspension_original' => $_POST['rear_suspension_original'],
    ':rear_suspension_details' => $_POST['rear_suspension_details'],
    ':front_suspension_type' => $_POST['front_suspension_type'],
    ':front_suspension_details_other' => $_POST['front_suspension_details_other'],
    ':rear_suspension_type' => $_POST['rear_suspension_type'],
    ':rear_suspension_details_other' => $_POST['rear_suspension_details_other'],
    ':front_adjustable_dampers' => $_POST['front_adjustable_dampers'],
    ':front_damper_adjusters' => is_numeric($_POST['front_damper_adjusters']) ? $_POST['front_damper_adjusters'] : null,
    ':rear_adjustable_dampers' => $_POST['rear_adjustable_dampers'],
    ':rear_damper_adjusters'  => is_numeric($_POST['rear_damper_adjusters']) ? $_POST['rear_damper_adjusters'] : null,
    ':anti_roll_bar' => $anti_roll_bar,


    // Engine
    ':engine_correct' => $_POST['engine_correct'],
    ':engine_details' => $_POST['engine_details'],
    ':engine_position_correct' => $_POST['engine_position_correct'],
    ':engine_position_details' => $_POST['engine_position_details'],
    ':engine_capacity' => $_POST['engine_capacity'],
    ':engine_stroke' => $_POST['engine_stroke'],
    ':engine_bore' => $_POST['engine_bore'],
    ':valve_size_exhaust' => $_POST['valve_size_exhaust'],
    ':valve_size_inlet' => $_POST['valve_size_inlet'],
    ':ignition' => $_POST['ignition'],

    // Fuel Supply
    ':fuel_type' => $_POST['fuel_type'],
    ':fuel_correct' => $_POST['fuel_correct'],
    ':fuel_details' => $_POST['fuel_details'],
    ':fuel_make' => $_POST['fuel_make'],
    ':fuel_size' => $_POST['fuel_size'],

    // Lubrication
    ':lubrication_correct' => $_POST['lubrication_correct'],
    ':lubrication_details' => $_POST['lubrication_details'],
    ':sump_type' => $_POST['sump_type'],
    ':oil_cooler' => $oil_cooler,



    // Gearbox, Transmission and clutch
    ':gearbox_make' => $_POST['gearbox_make'],
    ':gearbox_gears' => $_POST['gearbox_gears'],
    ':transmission_correct' => $_POST['transmission_correct'],
    ':transmission_details' => $_POST['transmission_details'],
    ':limited_slip' => $_POST['limited_slip'],
    ':clutch_type' => $_POST['clutch_type'],
    ':number_of_clutch_plates' => $_POST['number_of_clutch_plates'],
    ':operation' => $_POST['operation'],
    ':original_operation' => $_POST['original_operation'],

    // Front Brakes
    ':front_brakes_correct' => $_POST['front_brakes_correct'],
    ':front_brakes_details' => $_POST['front_brakes_details'],
    ':front_brake_type' => $_POST['front_brake_type'],
    ':front_brake_other' => $_POST['front_brake_other'],
    ':front_brake_diameter' => $_POST['front_brake_diameter'],
    ':front_brake_width' => $_POST['front_brake_width'],
    ':front_brake_calipers' => $_POST['front_brake_calipers'],
    ':bias_pedalbox' => $_POST['bias_pedalbox'],
    ':front_disk_type' => $_POST['front_disk_type'],
    ':front_disk_material' => $_POST['front_disk_material'],

    // Rear Brakes
    ':rear_brakes_correct' => $_POST['rear_brakes_correct'],
    ':rear_brakes_details' => $_POST['rear_brakes_details'],
    ':rear_brake_type' => $_POST['rear_brake_type'],
    ':rear_brake_other' => $_POST['rear_brake_other'],
    ':rear_brake_diameter' => $_POST['rear_brake_diameter'],
    ':rear_brake_width' => $_POST['rear_brake_width'],
    ':rear_brake_calipers' => $_POST['rear_brake_calipers'],
    ':rear_disk_type' => $_POST['rear_disk_type'],
    ':rear_disk_material' => $_POST['rear_disk_material'],

    // Body
    ':body_correct' => $_POST['body_correct'],
    ':body_details' => $_POST['body_details'],
    ':body_material' => $_POST['body_material'],
    ':body_other_materials' => $_POST['body_other_materials'],

    // Tyres
    ':tyre_brand' => $_POST['tyre_brand'],
    ':tyre_front_dimensions' => $_POST['tyre_front_dimensions'],
    ':tyre_rear_dimensions' => $_POST['tyre_rear_dimensions'],

    // Vehicle Photographs (File Paths)
    ':photo_front_right' => $photo_front_right,
    ':photo_rear_left' => $photo_rear_left,
    ':photo_front_brakes' => $photo_front_brakes,
    ':photo_rear_brakes' => $photo_rear_brakes,
    ':photo_dashboard' => $photo_dashboard,
    ':photo_engine_right' => $photo_engine_right,
    ':photo_engine_left' => $photo_engine_left,
    
    // Status
    ':status' => 'Pending'
]);
$submissionId = $pdo->lastInsertId();
$ownerName = $_POST['owner_name'];
$message = "🆕 New submission from $ownerName";

$stmt = $pdo->prepare("INSERT INTO admin_notifications (message, submission_id) VALUES (:message, :submission_id)");
$stmt->execute([
    'message' => $message,
    'submission_id' => $submissionId
]);


        // Redirect to success page
        header("Location: success.html");
        exit();

    } catch (PDOException $e) {
        echo "Database Error: " . $e->getMessage();
    }
} else {
    echo "Invalid Request.";
}



?>