<?php
require 'db_connect.php'; // Ensure database connection

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submission_id'], $_POST['image_field'])) {
    try {
        $submission_id = intval($_POST['submission_id']);
        $image_field = $_POST['image_field'];

        // ✅ Fetch existing submission
        $stmt = $pdo->prepare("SELECT * FROM car_submissions WHERE id = ?");
        $stmt->execute([$submission_id]);
        $submission = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$submission) {
            echo "<script>alert('Submission not found!'); window.history.back();</script>";
            exit();
        }

        // ✅ Handle image removal
        if (isset($_POST['remove_image'])) {
            $update_stmt = $pdo->prepare("UPDATE car_submissions SET $image_field = NULL WHERE id = ?");
            $update_stmt->execute([$submission_id]);

            // ✅ Delete file from server
            if (!empty($submission[$image_field]) && file_exists($submission[$image_field])) {
                unlink($submission[$image_field]);
            }

            echo "<script>alert('Image removed successfully!'); window.location.href='edit_submission.php?id=$submission_id';</script>";
            exit();
        }

        // ✅ Function to upload new image
        function uploadImage($input_name, $existing_image = null) {
            if (isset($_FILES[$input_name]) && $_FILES[$input_name]['error'] === 0) {
                $target_dir = "uploads/";
                if (!is_dir($target_dir)) {
                    mkdir($target_dir, 0775, true);
                }

                $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif'];
                $file_extension = strtolower(pathinfo($_FILES[$input_name]["name"], PATHINFO_EXTENSION));

                if (!in_array($file_extension, $allowed_extensions)) {
                    echo "<script>alert('Invalid file type. Please upload JPG, PNG, or GIF.'); window.history.back();</script>";
                    exit();
                }

                // ✅ Generate a unique filename
                $new_filename = $target_dir . uniqid() . "." . $file_extension;
                move_uploaded_file($_FILES[$input_name]["tmp_name"], $new_filename);

                // ✅ Delete old image if exists
                if ($existing_image && file_exists($existing_image)) {
                    unlink($existing_image);
                }

                return $new_filename;
            }
            return $existing_image;
        }

        // ✅ Handle image upload
        $new_image_path = uploadImage('new_image', $submission[$image_field]);

        // ✅ Update database with new image path
        $update_stmt = $pdo->prepare("UPDATE car_submissions SET $image_field = ? WHERE id = ?");
        $update_stmt->execute([$new_image_path, $submission_id]);

        // ✅ Success message and refresh page
        echo "<script>alert('Image updated successfully!'); window.location.href='edit_submission.php?id=$submission_id';</script>";
        exit();

    } catch (PDOException $e) {
        echo "<script>alert('Database Error: " . $e->getMessage() . "'); window.history.back();</script>";
    }
} else {
    echo "<script>alert('Invalid request!'); window.history.back();</script>";
}
?>
