<?php
session_start();
require 'db_connect.php';
require 'log_activity.php';

// Enable debugging during development
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // ✅ MARK ALL AS READ
    if (isset($_POST['mark_all_read'])) {
        $stmt = $pdo->query("UPDATE admin_notifications SET is_read = 1");
        if ($stmt) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'error' => 'Query failed']);
        }
        exit;
    }

    // ✅ STATUS UPDATE
    if (isset($_POST['id']) && isset($_POST['status'])) {
        $submissionId = intval($_POST['id']);
        $newStatus = $_POST['status'];

        if (!in_array($newStatus, ['Pending', 'Approved', 'Rejected'])) {
            echo json_encode(['error' => 'Invalid status']);
            exit;
        }

        $query = $pdo->prepare("UPDATE car_submissions SET status = :status WHERE id = :id");
        $success = $query->execute([':status' => $newStatus, ':id' => $submissionId]);

        if ($success) {
            logAdminActivity($_SESSION["admin_id"], $_SESSION["admin_username"], "Updated Submission ID: $submissionId to Status: $newStatus");

            $stmt = $pdo->prepare("SELECT owner_name FROM car_submissions WHERE id = :id");
            $stmt->execute(['id' => $submissionId]);
            $owner = $stmt->fetchColumn();

            $statusEmoji = [
                'Approved' => '✅',
                'Rejected' => '❌',
                'Pending' => '⏳'
            ];

            $message = "{$statusEmoji[$newStatus]} Submission from $owner marked as $newStatus";

            $stmt = $pdo->prepare("INSERT INTO admin_notifications (message, submission_id) VALUES (:message, :submission_id)");
            $stmt->execute([
                'message' => $message,
                'submission_id' => $submissionId
            ]);
        }

        echo json_encode(['success' => $success]);
    } else {
        echo json_encode(['error' => 'Invalid request']);
    }
} else {
    echo json_encode(['error' => 'Invalid method']);
}
