<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit();
}

require 'db_connect.php';

// Fetch all admin users with full details
$query = $pdo->query("SELECT id, username, full_name, email, profile_picture, last_login FROM admin_users ORDER BY id ASC");
$users = $query->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Users</title>
    <link rel="stylesheet" href="admin_styles.css">
</head>
<body>

   <?php include 'sidebar.php'; ?> <!-- Sidebar is included here -->

    <!-- Main Content -->
    <main class="admin-container">
        <h1>Manage Admin Users</h1>

        <table class="admin-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Profile Picture</th>
                    <th>Username</th>
                    <th>Full Name</th>
                    <th>Email</th>
                    <th>Last Login</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($users as $user): ?>
                    <tr>
                        <td><?= htmlspecialchars($user['id']) ?></td>
                        <td>
                            <?php if (!empty($user['profile_picture'])): ?>
                                <img src="uploads/<?= htmlspecialchars($user['profile_picture']) ?>" class="user-profile-pic">
                            <?php else: ?>
                                <img src="assets/default_profile.png" class="user-profile-pic">
                            <?php endif; ?>
                        </td>
                        <td><?= htmlspecialchars($user['username']) ?></td>
                        <td><?= htmlspecialchars($user['full_name']) ?></td>
                        <td><?= htmlspecialchars($user['email']) ?></td>
                        <td><?= !empty($user['last_login']) ? $user['last_login'] : "Never Logged In" ?></td>
                        <td>
                            <a href="edit_user.php?id=<?= $user['id'] ?>" class="edit-btn">Edit</a>
                            <a href="delete_user.php?id=<?= $user['id'] ?>" class="delete-btn" onclick="return confirm('Are you sure you want to delete this user?')">Delete</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <a href="register_admin.php" class="add-user-btn">Add New Admin</a>
    </main>

    <style>
        /* ✅ Admin Panel Styling */
        .admin-container {
            padding: 20px;
            margin-left: 280px; /* Matches sidebar width */
        }
        .admin-table {
            width: 100%;
            border-collapse: collapse;
            background: #fff;
            border-radius: 5px;
            overflow: hidden;
        }
        .admin-table th, .admin-table td {
            padding: 12px;
            border-bottom: 1px solid #ddd;
            text-align: center;
        }
        .user-profile-pic {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            object-fit: cover;
        }
        .edit-btn, .delete-btn {
            padding: 5px 10px;
            text-decoration: none;
            border-radius: 5px;
        }
        .edit-btn {
            background-color: #007bff;
            color: white;
        }
        .delete-btn {
            background-color: red;
            color: white;
        }
        .add-user-btn {
            display: inline-block;
            margin-top: 15px;
            padding: 10px 15px;
            background: green;
            color: white;
            text-decoration: none;
            border-radius: 5px;
        }
    </style>

</body>
</html>
