<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit();
}

require 'db_connect.php'; // Include database connection

// Check if submission ID is provided
if (!isset($_GET['id']) || empty($_GET['id'])) {
    die("Invalid submission ID.");
}

// Get the submission ID from the URL
$submission_id = intval($_GET['id']);

// Fetch submission data
$query = $pdo->prepare("SELECT * FROM car_submissions WHERE id = :id");
$query->execute([':id' => $submission_id]);
$submission = $query->fetch(PDO::FETCH_ASSOC);

// Check if submission exists
if (!$submission) {
    die("Submission not found.");
}
// ✅ Dynamic title setup
$dynamicTitle = "Vehicle details for '" . htmlspecialchars($submission['owner_name']) . "'s " . htmlspecialchars($submission['vehicle_model']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Submission</title>
    <link rel="stylesheet" href="admin_styles.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
    @media print {
    /* Hide sidebar and other non-essential elements */
    .sidebar, .action-buttons {
        display: none !important;
    }

    /* Ensure the main content is centered */
    .admin-container {
        margin: 0 auto !important;
        width: 90% !important;
        text-align: left !important;
    }

    /* Ensure images fit within the print page */
    .submission-image img {
        max-width: 100% !important; /* Prevents overflow */
        height: auto !important; /* Maintain aspect ratio */
        display: block; /* Ensures images are properly contained */
        margin: 10px auto; /* Centers the images */
        page-break-inside: avoid; /* Avoids cutting images across pages */
    }

    /* Ensure tables don't break */
    .submission-table {
        width: 100%;
        border-collapse: collapse;
    }

    .submission-table td, .submission-table th {
        border: 1px solid #ddd;
        padding: 8px;
        word-wrap: break-word; /* Prevents content from breaking layout */
    }
}

</style>

</head>
<body>

  <?php include 'sidebar.php'; ?> <!-- Sidebar is included here -->



    <!-- Main Content (FIXED Layout Issue) -->
    <main class="admin-container">
        <h1>Submission Details</h1>
        <h3><?= $dynamicTitle ?></h3> <!-- ✅ Dynamic Title Added -->

        <!-- Action Buttons -->
        <div class="action-buttons">
            <button onclick="window.print()">🖨 Print</button>
            <button onclick="window.location.href='export_pdf.php?id=<?= $submission_id ?>'">📄 Export to PDF</button>
            <button onclick="window.location.href='edit_submission.php?id=<?= $submission_id ?>'">✏️ Edit Submission</button>
        </div>

        <div class="submission-section">
    <h2>Owner & Vehicle Details</h2>
    <table class="submission-table">
        <tr><td>Driver/Owner Name:</td><td><?= htmlspecialchars($submission['owner_name']) ?></td></tr>
        <tr><td>Email:</td><td><?= htmlspecialchars($submission['email']) ?></td></tr>
        <tr><td>Vehicle Model:</td><td><?= htmlspecialchars($submission['vehicle_model']) ?></td></tr>
        <tr><td>Equipe Series:</td><td><?= htmlspecialchars($submission['equipe_series']) ?></td></tr>
        <tr><td>Equipe Class:</td><td><?= htmlspecialchars($submission['equipe_class']) ?></td></tr>
        <tr><td>Conforms to Equipe Series Regulations:</td><td><?= htmlspecialchars($submission['spec_conform']) ?></td></tr>
        <tr><td>Specification Details:</td><td><?= htmlspecialchars($submission['spec_details']) ?></td></tr>
        <tr><td>FIA Homologation Number:</td><td><?= htmlspecialchars($submission['fia_homologation']) ?></td></tr>
    </table>
</div>
<div class="submission-section">
    <h2>Chassis</h2>
    <table class="submission-table">
        <tr><td>Chassis Period Correct:</td><td><?= htmlspecialchars($submission['chassis_correct']) ?></td></tr>
        <tr><td>Chassis Additional Details:</td><td><?= htmlspecialchars($submission['chassis_details']) ?></td></tr>
        <tr><td>Chassis Material:</td><td><?= htmlspecialchars($submission['chassis_material']) ?></td></tr>
        <tr><td>Chassis Construction:</td><td><?= htmlspecialchars($submission['chassis_construction']) ?></td></tr>
        <tr><td>Additional Stiffening:</td><td><?= htmlspecialchars($submission['chassis_stiffening']) ?></td></tr>
        <tr><td>Stiffening Details:</td><td><?= htmlspecialchars($submission['chassis_stiffening_details']) ?></td></tr>
    </table>
</div>    
<div class="submission-section">
    <h2>Suspension</h2>
    <table class="submission-table">
        <tr><td>Front Suspension in original position?:</td><td><?= htmlspecialchars($submission['front_suspension_original']) ?></td></tr>
        <tr><td>If no, additional details?:</td><td><?= htmlspecialchars($submission['front_suspension_details']) ?></td></tr>
        <tr><td>Rear Suspension in original position?:</td><td><?= htmlspecialchars($submission['rear_suspension_original']) ?></td></tr>
        <tr><td>If no, additional details?:</td><td><?= htmlspecialchars($submission['rear_suspension_details']) ?></td></tr>
        <tr><td>Front Suspension Type:</td><td><?= htmlspecialchars($submission['front_suspension_type']) ?></td></tr>
        <tr><td>If 'Other' additional details:</td><td><?= htmlspecialchars($submission['front_suspension_details_other']) ?></td></tr>
        <tr><td>Rear Suspension Type:</td><td><?= htmlspecialchars($submission['rear_suspension_type']) ?></td></tr>
        <tr><td>If 'Other' additional details:</td><td><?= htmlspecialchars($submission['rear_suspension_details_other']) ?></td></tr>
        <tr><td>Front adjustable dampers?:</td><td><?= htmlspecialchars($submission['front_adjustable_dampers']) ?></td></tr>
        <tr><td>If Yes, how many adjustments?:</td><td><?= htmlspecialchars($submission['front_damper_adjusters']) ?></td></tr>
        <tr><td>Rear adjustable dampers?:</td><td><?= htmlspecialchars($submission['rear_adjustable_dampers']) ?></td></tr>
        <tr><td>If Yes, how many adjustments?:</td><td><?= htmlspecialchars($submission['rear_damper_adjusters']) ?></td></tr>
        <tr><td>Is an anti roll bar fitted?:</td><td><?= htmlspecialchars($submission['anti_roll_bar']) ?></td></tr>
    </table>
</div>
<div class="submission-section">
    <h2>Engine</h2>
    <table class="submission-table">
        
        <tr><td>Engine Period Correct:</td><td><?= htmlspecialchars($submission['engine_correct']) ?></td></tr>
        <tr><td>If no - additional details:</td><td><?= htmlspecialchars($submission['engine_details']) ?></td></tr>
        <tr><td>Engine Position Correct:</td><td><?= htmlspecialchars($submission['engine_position_correct']) ?></td></tr>
        <tr><td>If no - additional details:</td><td><?= htmlspecialchars($submission['engine_position_details']) ?></td></tr>
        <tr><td>Engine Capacity (cc):</td><td><?= htmlspecialchars($submission['engine_capacity']) ?></td></tr>
        <tr><td>Engine Stroke (mm):</td><td><?= htmlspecialchars($submission['engine_stroke']) ?></td></tr>
        <tr><td>Engine Bore (mm):</td><td><?= htmlspecialchars($submission['engine_bore']) ?></td></tr>
        <tr><td>Intake Valve Diameter (mm):</td><td><?= htmlspecialchars($submission['valve_size_inlet']) ?></td></tr>
        <tr><td>Exhaust Valve Diameter (mm):</td><td><?= htmlspecialchars($submission['valve_size_exhaust']) ?></td></tr>
        <tr><td>Ignition Type:</td><td><?= htmlspecialchars($submission['ignition']) ?></td></tr>
    </table>
</div>
<div class="submission-section">
    <h2>Fuel Supply</h2>
    <table class="submission-table">
        <tr><td>Fuel Injecton or Carburettor:</td><td><?= htmlspecialchars($submission['fuel_type']) ?></td></tr>
        <tr><td>Fuel System Period Correct?</td><td><?= htmlspecialchars($submission['fuel_correct']) ?></td></tr>
        <tr><td>If no, Additional details:</td><td><?= htmlspecialchars($submission['fuel_details']) ?></td></tr>
        <tr><td>Fuel System Make:</td><td><?= htmlspecialchars($submission['fuel_make']) ?></td></tr>
        <tr><td>Carburrettor type and size:</td><td><?= htmlspecialchars($submission['fuel_size']) ?></td></tr>
    </table>
</div>    
<div class="submission-section">
    <h2>Lubrication</h2>
    <table class="submission-table">
        <tr><td>Lubrication Period Correct:</td><td><?= htmlspecialchars($submission['lubrication_correct']) ?></td></tr>
        <tr><td>If no - additional details:</td><td><?= htmlspecialchars($submission['lubrication_details']) ?></td></tr>
        <tr><td>Dry/Wet Sump</td><td><?= htmlspecialchars($submission['sump_type']) ?></td></tr>
        <tr><td>Oil Cooler:</td><td><?= htmlspecialchars($submission['oil_cooler']) ?></td></tr>
    </table>
</div>
<div class="submission-section">
    <h2>Gearbox, Transmission and Clutch</h2>
    <table class="submission-table">
        <tr><td>Gearbox Make:</td><td><?= htmlspecialchars($submission['gearbox_make']) ?></td></tr>
        <tr><td>Number of Forward Gears:</td><td><?= htmlspecialchars($submission['gearbox_gears']) ?></td></tr>
        <tr><td>Is the transmission period correct?</td><td><?= htmlspecialchars($submission['transmission_correct']) ?></td></tr>
        <tr><td>If not, additional details:</td><td><?= htmlspecialchars($submission['transmission_details']) ?></td></tr>
        <tr><td>Final Drive a LSD?:</td><td><?= htmlspecialchars($submission['limited_slip']) ?></td></tr>
        <tr><td>Clutch Type:</td><td><?= htmlspecialchars($submission['clutch_type']) ?></td></tr>
        <tr><td>Number Of Clutch Plates:</td><td><?= htmlspecialchars($submission['number_of_clutch_plates']) ?></td></tr>
        <tr><td>Clutch Operation:</td><td><?= htmlspecialchars($submission['operation']) ?></td></tr>
        <tr><td>Original Operation:</td><td><?= htmlspecialchars($submission['original_operation']) ?></td></tr>
    </table>
</div>
<div class="submission-section">
    <h2>Front Brakes</h2>
    <table class="submission-table">
        <tr><td>Front Brake period correct?</td><td><?= htmlspecialchars($submission['front_brakes_correct']) ?></td></tr>
        <tr><td>If no - additional details:</td><td><?= htmlspecialchars($submission['front_brakes_details']) ?></td></tr>
        <tr><td>Front Brake Type:</td><td><?= htmlspecialchars($submission['front_brake_type']) ?></td></tr>
        <tr><td>If 'Other'- additional details:</td><td><?= htmlspecialchars($submission['front_brake_other']) ?></td></tr>
        <tr><td>Front Brake Diameter (mm):</td><td><?= htmlspecialchars($submission['front_brake_diameter']) ?></td></tr>
        <tr><td>Front Brake Width (mm):</td><td><?= htmlspecialchars($submission['front_brake_width']) ?></td></tr>
        <tr><td>Number of front brake Calipers/pistons (per Wheel) :</td><td><?= htmlspecialchars($submission['front_brake_calipers']) ?></td></tr>
        <tr><td>Bias Pedalbox? :</td><td><?= htmlspecialchars($submission['bias_pedalbox']) ?></td></tr>
        <tr><td>Front Disk Type :</td><td><?= htmlspecialchars($submission['front_disk_type']) ?></td></tr>
        <tr><td>Front Disk Material:</td><td><?= htmlspecialchars($submission['front_disk_material']) ?></td></tr>
    </table>
</div>
<div class="submission-section">
    <h2>Rear Brakes</h2>
    <table class="submission-table">
        <tr><td>Rear Brake period correct?</td><td><?= htmlspecialchars($submission['rear_brakes_correct']) ?></td></tr>
        <tr><td>If no - additional details:</td><td><?= htmlspecialchars($submission['rear_brakes_details']) ?></td></tr>
        <tr><td>Rear Brake Type:</td><td><?= htmlspecialchars($submission['rear_brake_type']) ?></td></tr>
        <tr><td>If 'Other'- additional details:</td><td><?= htmlspecialchars($submission['rear_brake_other']) ?></td></tr>
        <tr><td>Rear Brake Diameter (mm):</td><td><?= htmlspecialchars($submission['rear_brake_diameter']) ?></td></tr>
        <tr><td>Rear Brake Width (mm):</td><td><?= htmlspecialchars($submission['rear_brake_width']) ?></td></tr>
        <tr><td>Number of rear brake Calipers/pistons (per Wheel) :</td><td><?= htmlspecialchars($submission['rear_brake_calipers']) ?></td></tr>
        <tr><td>Rear Disk Type :</td><td><?= htmlspecialchars($submission['rear_disk_type']) ?></td></tr>
        <tr><td>Rear Disk Material:</td><td><?= htmlspecialchars($submission['rear_disk_material']) ?></td></tr>
    </table>
</div>
<div class="submission-section">
    <h2>Body</h2>
    <table class="submission-table">
        <tr><td>Body Period Correct:</td><td><?= htmlspecialchars($submission['body_correct']) ?></td></tr>
        <tr><td>If no, Additional details:</td><td><?= htmlspecialchars($submission['body_details']) ?></td></tr>
        <tr><td>Main body material:</td><td><?= htmlspecialchars($submission['body_material']) ?></td></tr>
        <tr><td>Other body materials:</td><td><?= htmlspecialchars($submission['body_other_materials']) ?></td></tr>
    </table>
</div>     
<div class="submission-section">
    <h2>Tyres</h2>
    <table class="submission-table">  
        <tr><td>Tyre Brand:</td><td><?= htmlspecialchars($submission['tyre_brand']) ?></td></tr>
        <tr><td>Tyre Front Dimensions:</td><td><?= htmlspecialchars($submission['tyre_front_dimensions']) ?></td></tr>
        <tr><td>Tyre Rear Dimensions:</td><td><?= htmlspecialchars($submission['tyre_rear_dimensions']) ?></td></tr>
    </table>
</div>  
<!-- ✅ Photographs Section -->
<div class="submission-section">
    <h2>Photographs</h2>
    <table class="submission-table">
        <tr>
            <td>Front 3/4 View Right:</td>
            <td><img src="<?= htmlspecialchars($submission['photo_front_right']) ?>" class="submission-image"></td>
        </tr>
        <tr>
            <td>Rear 3/4 View Left:</td>
            <td><img src="<?= htmlspecialchars($submission['photo_rear_left']) ?>" class="submission-image"></td>
        </tr>
        <tr>
            <td>Front Brakes & Suspension:</td>
            <td><img src="<?= htmlspecialchars($submission['photo_front_brakes']) ?>" class="submission-image"></td>
        </tr>
        <tr>
            <td>Rear Brakes & Suspension:</td>
            <td><img src="<?= htmlspecialchars($submission['photo_rear_brakes']) ?>" class="submission-image"></td>
        </tr>
        <tr>
            <td>Dashboard:</td>
            <td><img src="<?= htmlspecialchars($submission['photo_dashboard']) ?>" class="submission-image"></td>
        </tr>
        <tr>
            <td>Engine Compartment (Right):</td>
            <td><img src="<?= htmlspecialchars($submission['photo_engine_right']) ?>" class="submission-image"></td>
        </tr>
        <tr>
            <td>Engine Compartment (Left):</td>
            <td><img src="<?= htmlspecialchars($submission['photo_engine_left']) ?>" class="submission-image"></td>
        </tr>
    </table>
</div>


    </section>

      <style>
      .submission-image {
    max-width: 300px; /* ✅ Limits the max width to 300px */
    height: auto; /* ✅ Maintains aspect ratio */
    display: block; /* ✅ Ensures proper alignment */
    margin: 10px auto; /* ✅ Centers images */
    border: 1px solid #ddd; /* ✅ Optional: Adds a subtle border */
    padding: 5px; /* ✅ Adds spacing */
    background: white;
    box-shadow: 2px 2px 10px rgba(0, 0, 0, 0.1); /* ✅ Adds a slight shadow */
}

        /* ✅ Ensuring the Main Content Aligns Properly */
        .admin-container {
            padding: 20px;
            margin-left: 280px; /* Matches sidebar width */
            max-width: 80%; /* Keeps form centered */
        }
        
        .action-buttons {
            margin-bottom: 20px;
        }
        .action-buttons button {
            margin-right: 10px;
            padding: 10px;
            border: none;
            cursor: pointer;
            background-color: #007bff;
            color: white;
        }

        .submission-section {
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }

        .submission-table {
            width: 100%;
            border-collapse: collapse;
        }

        .submission-table td {
            padding: 10px;
            border-bottom: 1px solid #ddd;
        }

        .submission-image {
            max-width: 400px;
            margin: 10px;
            border-radius: 5px;
        }
    </style>
</body>
</html>
